/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.ContentsStoreAgent;
import org.logical_paradox.rss.rcm.RCMContentsRegister;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

public class RCMContentsRegisterImpl
extends UnicastRemoteObject
implements RCMContentsRegister {
    private static final long serialVersionUID = -3491241043496340100L;
    private static final Log log = LogFactory.getLog(RCMContentsRegisterImpl.class);
    protected ContentsAccessor accessor = null;
    protected RSSRCMConfig cfg = null;
    private final String rkey;
    private ContentsStoreAgent[] agents = null;

    public RCMContentsRegisterImpl(String registerName, RSSRCMConfig conf, ContentsAccessor a) throws RemoteException {
        this.rkey = registerName;
        this.accessor = a;
        this.cfg = conf;
        log.info((Object)("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9[" + this.rkey + "]\u3092\u521d\u671f\u5316\u3057\u3066\u3044\u307e\u3059"));
        this.agents = new ContentsStoreAgent[this.cfg.getAgentsPerRegister()];
        for (int i = 0; i < this.agents.length; ++i) {
            this.agents[i] = new ContentsStoreAgent(a, this.cfg);
        }
        log.info((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092" + this.agents.length + "\u500b\u751f\u6210\u3057\u307e\u3057\u305f"));
        log.info((Object)("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9\u304c[" + this.rkey + "]\u3068\u3044\u3046\u540d\u524d\u3067\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f"));
        this.start();
    }

    protected void start() {
        for (int i = 0; i < this.agents.length; ++i) {
            this.agents[i].start();
        }
        log.info((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
    }

    protected void stop() {
        try {
            for (ContentsStoreAgent agent : this.agents) {
                agent.done();
            }
            for (ContentsStoreAgent agent : this.agents) {
                agent.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }

    public String getRegisterName() throws RemoteException {
        return this.rkey;
    }

    public void registContents(WebContents contents) throws RemoteException {
        try {
            this.cfg.getContentsQueue().enqueue(contents);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isRegistered(String url) throws RemoteException {
        try {
            return this.accessor.find(url) != null;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void unregistContents(String url) throws RemoteException {
        try {
            this.accessor.unregist(url);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void unregistAll() throws RemoteException {
        try {
            this.accessor.unregistAll();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public String getRegisterKey() throws RemoteException {
        return this.rkey;
    }

    public void shutdown() throws RemoteException {
        this.stop();
    }
}

