/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.oqs4r;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.oqs4r.EmptyCache;
import org.logical_paradox.rss.oqs4r.GC;
import org.logical_paradox.rss.oqs4r.OQS4RConfig;
import org.logical_paradox.rss.oqs4r.OQSConnection;
import org.logical_paradox.rss.oqs4r.OQSConnectionImpl;
import org.logical_paradox.rss.oqs4r.ObjectQueueServer;

public class ObjectQueueServerImpl
extends UnicastRemoteObject
implements ObjectQueueServer {
    private static final long serialVersionUID = 6684624188431248188L;
    private static final Log logger = LogFactory.getLog(ObjectQueueServerImpl.class);
    public static final String OQS4R_CONFIG_FILENAME = "../conf/oqs4r.conf";
    private String oqs4rConfigFilename = "../conf/oqs4r.conf";
    private String nodeId = null;
    private GC gc;
    protected Cache queue = new Cache();
    protected OQSConnection[] preparedConnections = null;
    protected int nextidx = 0;
    protected OQS4RConfig config;

    protected ObjectQueueServerImpl() throws RemoteException {
    }

    protected ObjectQueueServerImpl(String filename) throws RemoteException {
        this();
        this.oqs4rConfigFilename = filename;
    }

    public void start() throws Exception {
        this.config = new OQS4RConfig(this.oqs4rConfigFilename);
        if (this.config.isTestMode()) {
            logger.info((Object)"\u30c6\u30b9\u30c8\u30e2\u30fc\u30c9\u306e\u305f\u3081\uff0c\u30ad\u30e5\u30fc\u30a4\u30f3\u30b0\u3092\u3057\u307e\u305b\u3093");
            this.queue = new EmptyCache();
        }
        this.nodeId = LookupFactory.getLookup(this.config.getDSRName()).bind(40, this);
        int connections = this.config.getPreparedConnections();
        this.preparedConnections = new OQSConnection[connections];
        for (int i = 0; i < this.preparedConnections.length; ++i) {
            this.preparedConnections[i] = new OQSConnectionImpl(this);
        }
        logger.info((Object)("Object Queue Server ['" + this.nodeId + "']\u3092\u958b\u59cb\u3057\u307e\u3057\u305f"));
        this.gc = new GC(this.queue, this.config.getCacheExpireSec());
        this.gc.start();
    }

    public Serializable next() throws Exception {
        return this.next(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable next(boolean blocking) throws Exception {
        if (!blocking) {
            Cache cache = this.queue;
            synchronized (cache) {
                return (Serializable)this.queue.getOne();
            }
        }
        Serializable rc = null;
        Cache cache = this.queue;
        synchronized (cache) {
            while (this.queue.size() == 0) {
                this.queue.wait();
            }
            rc = (Serializable)this.queue.getOne();
            this.queue.notifyAll();
        }
        logger.info((Object)("\u30c7\u30ad\u30e5\u30fc:" + rc.toString()));
        return rc;
    }

    public void add(Serializable o) throws Exception {
        this.queue.add((Object)o);
        logger.info((Object)("\u30a8\u30f3\u30ad\u30e5\u30fc:" + o.toString()));
    }

    protected Cache getCache() {
        return this.queue;
    }

    public OQSConnection getConnection() throws RemoteException {
        OQSConnection aConnection = this.preparedConnections[this.nextidx++];
        if (this.nextidx >= this.preparedConnections.length) {
            this.nextidx = 0;
        }
        return aConnection;
    }

    public String getName() throws RemoteException {
        return this.nodeId;
    }

    public String getFqsn() throws RemoteException {
        return this.nodeId + "@" + this.config.getDSRName();
    }

    public void shutdown(boolean force) throws RemoteException {
        logger.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059");
        this.gc.shutdown();
        for (int i = 0; i < this.preparedConnections.length; ++i) {
            if (this.preparedConnections[i] != null) {
                ObjectQueueServerImpl.unexportObject(this.preparedConnections[i], force);
            }
            logger.info((Object)"\u63a5\u7d9a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u89e3\u653e\u3057\u307e\u3057\u305f");
        }
        try {
            logger.info((Object)"Object Queue Server\u3092DSR\u304b\u3089\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059");
            LookupFactory.getLookup(this.config.getDSRName()).unbind(40, this.nodeId);
        }
        catch (Exception e1) {
            throw new RemoteException(e1.getMessage());
        }
        UnicastRemoteObject.unexportObject(this, force);
        logger.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }
}

