/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lookup;

import java.util.HashMap;
import java.util.ResourceBundle;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.Lookup;
import org.logical_paradox.rss.lookup.impl.HashMapLookup;
import org.logical_paradox.rss.lookup.impl.RMILookup;

public class LookupFactory {
    private static ResourceBundle resource = null;
    public static final String DEFAULT_FACTORY_RESOURCE = "lookupfactory";
    public static final int ON_RMI = 1;
    public static final int ON_HASHMAP = 2;
    public static final int DEFAULT_LOOKUP_IMPL = 1;
    public static final HashMap<String, HashMapLookup> hashMapLookups = new HashMap();

    public static Lookup getLookup(String bindTarget) throws Exception {
        if (resource == null) {
            LookupFactory.setLookupFactoryResource(DEFAULT_FACTORY_RESOURCE);
        }
        return LookupFactory.getLookup(bindTarget, Integer.parseInt(resource.getString("DEFAULT_LOOKUP_TYPE")));
    }

    public static void setLookupFactoryResource(String rn) {
        resource = ResourceBundle.getBundle(rn);
    }

    public static void register(RSSDistributedServiceRegistry service) throws Exception {
        if (resource == null) {
            LookupFactory.setLookupFactoryResource(DEFAULT_FACTORY_RESOURCE);
        }
        LookupFactory.register(service, Integer.parseInt(resource.getString("DEFAULT_LOOKUP_TYPE")));
    }

    public static void register(RSSDistributedServiceRegistry service, int type) throws Exception {
        switch (type) {
            case 1: {
                new RMILookup().register(service);
                break;
            }
            case 2: {
                String key = service.getName() + ":" + type;
                HashMapLookup lookup = hashMapLookups.get(key);
                if (lookup == null) {
                    lookup = new HashMapLookup(service.getName());
                    hashMapLookups.put(key, lookup);
                }
                lookup.register(service);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static Lookup getLookup(String bindTarget, int type) throws Exception {
        switch (type) {
            case 1: {
                return new RMILookup(bindTarget);
            }
            case 2: {
                String key = bindTarget + ":" + type;
                HashMapLookup lookup = hashMapLookups.get(key);
                if (lookup == null) {
                    lookup = new HashMapLookup(bindTarget);
                    hashMapLookups.put(key, lookup);
                }
                return lookup;
            }
        }
        throw new IllegalArgumentException();
    }
}

