/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lcmgr.persister;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.logical_paradox.rss.http.WebContents;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLPersister {
    private XMLPersister() {
    }

    public static final String marshall(WebContents webContents) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Contents");
        Element documentElement = document.createElement("Document");
        documentElement.appendChild(document.createTextNode(webContents.getDocument()));
        Element locationElement = document.createElement("Location");
        locationElement.appendChild(document.createTextNode(webContents.getLocation()));
        Element documentTitleElement = document.createElement("Title");
        documentTitleElement.appendChild(document.createTextNode(webContents.getTitle()));
        Element sitenameElement = document.createElement("SiteName");
        sitenameElement.appendChild(document.createTextNode(webContents.getSitename()));
        Element contentTypeElement = document.createElement("MimeType");
        contentTypeElement.appendChild(document.createTextNode(webContents.getContentType()));
        rootElement.appendChild(documentElement);
        rootElement.appendChild(locationElement);
        rootElement.appendChild(documentTitleElement);
        rootElement.appendChild(sitenameElement);
        rootElement.appendChild(contentTypeElement);
        document.appendChild(rootElement);
        StringWriter xmlWriter = new StringWriter();
        TransformerFactory tffactory = TransformerFactory.newInstance();
        Transformer transformer = tffactory.newTransformer();
        transformer.setOutputProperty("encoding", "Windows-31J");
        DOMSource src = new DOMSource();
        src.setNode(document);
        StreamResult target = new StreamResult();
        target.setWriter(xmlWriter);
        transformer.transform(src, target);
        return xmlWriter.getBuffer().toString();
    }

    public static final WebContents unmarshall(String document) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream(document.getBytes());
        Document doc = builder.parse(in);
        WebContents contents = new WebContents();
        Node root = doc.getFirstChild();
        NodeList webContentsElements = root.getChildNodes();
        for (int i = 0; i < webContentsElements.getLength(); ++i) {
            Node node = webContentsElements.item(i);
            String nodename = node.getNodeName();
            String nodevalue = node.getFirstChild().getNodeValue();
            if ("Document".equals(nodename)) {
                contents.setDocument(nodevalue);
                continue;
            }
            if ("Location".equals(nodename)) {
                contents.setLocation(nodevalue);
                continue;
            }
            if ("Title".equals(nodename)) {
                contents.setTitle(nodevalue);
                continue;
            }
            if ("SiteName".equals(nodename)) {
                contents.setSitename(nodevalue);
                continue;
            }
            if (!"MimeType".equals(nodename)) continue;
            contents.setContentType(nodevalue);
        }
        return contents;
    }
}

