/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http.contents;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.rss.http.RSSHttpResponse;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.http.contents.ContentsAnalyzer;
import org.logical_paradox.rss.http.contents.ContentsFilter;
import org.logical_paradox.rss.http.contents.HTMLContentsFilter;

public class DefaultContentsAnalyzer
implements ContentsAnalyzer {
    private static final ContentsFilter htmlContentsFilter = new HTMLContentsFilter();

    public WebContents analyze(RSSHttpResponse response, String contents) {
        WebContents wc = new WebContents();
        if (response.getResponseCode() < 0) {
            throw new IllegalStateException("HttpURLConnection object has no content");
        }
        wc.setOriginalDocument(contents);
        wc.setURL(response.getURL());
        wc.setLocation(response.getURL().toString());
        wc.setContentType(response.getContentType());
        wc.setResponseCode(response.getResponseCode());
        if (wc.getLocation().indexOf("robots.txt") >= 0) {
            wc.setRobotsTxtFlg(true);
        } else {
            wc.setRobotsTxtFlg(false);
        }
        wc.setDocument(this.normalizeDocument(contents));
        wc.setSitename(this.getSiteName(contents));
        wc.setTitle(this.getTitle(contents));
        return wc;
    }

    protected String normalizeDocument(String contents) {
        return StringUtils.isEmpty((String)contents) ? "" : htmlContentsFilter.filter(contents);
    }

    protected String getSiteName(String contents) {
        return "undefined site name";
    }

    protected String getTitle(String contents) {
        return "undefined document title";
    }
}

