/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;

public class RobotAcceptanceRule {
    public static final String HEADER_USER_AGENT = "User-agent: ";
    public static final String HEADER_DISALLOW = "Disallow: ";
    private LinkedList<UserAgentRuleDirective> disallows = new LinkedList();

    protected RobotAcceptanceRule() {
    }

    public static RobotAcceptanceRule getInstance(InputStream in) throws IOException {
        RobotAcceptanceRule r = new RobotAcceptanceRule();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String linebuf = null;
        int cnt = -1;
        while ((linebuf = reader.readLine()) != null) {
            if (linebuf.startsWith(HEADER_USER_AGENT)) {
                String robot = linebuf.substring(HEADER_USER_AGENT.length()).trim();
                if (robot.length() <= 0) continue;
                ++cnt;
                r.disallows.add(r.newRuleDirective(robot));
                continue;
            }
            if (!linebuf.startsWith(HEADER_DISALLOW) || cnt < 0) continue;
            UserAgentRuleDirective ua = r.disallows.get(cnt);
            String param = linebuf.substring(HEADER_DISALLOW.length()).trim();
            ua.add(param);
        }
        reader.close();
        return r;
    }

    private UserAgentRuleDirective newRuleDirective(String r) {
        return new UserAgentRuleDirective(r);
    }

    protected boolean isAllowed(String url, String agent) {
        UserAgentRuleDirective u = this.matchedDirective(agent);
        if (u == null) {
            return true;
        }
        try {
            String path = new URL(url).getPath();
            ListIterator i = u.getIterator();
            while (i.hasNext()) {
                String ua = (String)i.next();
                if (ua.trim().length() <= 0 || !path.startsWith(ua)) continue;
                return false;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    protected UserAgentRuleDirective matchedDirective(String agent) {
        if (agent == null) {
            return null;
        }
        for (UserAgentRuleDirective u : this.disallows) {
            if (!agent.equals(u.getUserAgent()) && !u.getUserAgent().equals("*")) continue;
            return u;
        }
        return null;
    }

    class UserAgentRuleDirective {
        private String agent = null;
        private LinkedList<String> disallows = null;

        public UserAgentRuleDirective(String name) {
            this.agent = name;
            this.disallows = new LinkedList();
        }

        public String getUserAgent() {
            return this.agent;
        }

        public ListIterator getIterator() {
            return this.disallows.listIterator();
        }

        public int size() {
            return this.disallows.size();
        }

        public void add(String path) {
            this.disallows.add(path);
        }

        public void remove(String path) {
            this.disallows.remove(path);
        }
    }
}

