/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.logical_paradox.rss.http.NoIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchorCollectionCallback
extends HTMLEditorKit.ParserCallback {
    private OutputStreamWriter out;
    private Vector<String> anchors = new Vector();
    private boolean acceptIndex = true;
    private boolean acceptFollow = true;

    public AnchorCollectionCallback() {
        this.out = null;
    }

    public AnchorCollectionCallback(OutputStreamWriter writer) {
        this.out = writer;
    }

    public int size() {
        return this.anchors.size();
    }

    public void clean() {
        this.anchors.removeAllElements();
        this.acceptFollow = true;
        this.acceptIndex = true;
    }

    public Vector<String> getAnchors() throws NoIndexException {
        if (!this.acceptIndex) {
            if (this.acceptFollow) {
                throw new NoIndexException("case 1", this.anchors);
            }
            throw new NoIndexException("case 2");
        }
        if (!this.acceptFollow) {
            return null;
        }
        return this.anchors;
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        super.handleStartTag(t, a, pos);
        String tag = t.toString().trim().toLowerCase();
        if (tag.equals("meta")) {
            this.handleMetaTag(t, a, pos);
        } else if (tag.equals("a") || tag.equals("area")) {
            this.handleAnchorTag(t, a, pos);
        }
    }

    public void handleMetaTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        Enumeration<?> e = a.getAttributeNames();
        String content = null;
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key != null && key.toString().trim().toLowerCase().equals("name")) {
                String prop = (String)a.getAttribute(key);
                if (prop.trim().toLowerCase().equals("robots")) continue;
                return;
            }
            if (key == null || !key.toString().trim().toLowerCase().equals("content")) continue;
            content = (String)a.getAttribute(key);
        }
        if (content == null || content.trim().length() == 0) {
            return;
        }
        String[] param = content.split(",");
        if (param == null || param.length == 0) {
            return;
        }
        String p = null;
        for (int i = 0; i < param.length; ++i) {
            p = param[i].trim().toLowerCase();
            if (p.equals("noindex")) {
                this.acceptIndex = false;
                continue;
            }
            if (!p.equals("nofollow")) continue;
            this.acceptFollow = false;
        }
    }

    public void handleAnchorTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        Enumeration<?> e = a.getAttributeNames();
        String href = null;
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key == null || !key.toString().trim().toLowerCase().equals("href")) continue;
            href = (String)a.getAttribute(key);
            break;
        }
        if (href != null) {
            this.anchors.addElement(href);
            if (this.out != null) {
                try {
                    this.out.write(href);
                    this.out.write("\n");
                    this.out.flush();
                }
                catch (Exception ioe) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.handleStartTag(t, a, pos);
    }
}

