/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsync;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueueException;

public class SyncQueue {
    public static final int SYNCQUEUE_SIZE = 65536;
    private int packageSize;
    private Hashtable<String, Hashtable<String, SyncCommand>> buf = new Hashtable();

    public SyncQueue() {
        this.packageSize = 65536;
    }

    public SyncQueue(int p) {
        this.packageSize = p;
    }

    public void add(SyncCommand o) throws SyncQueueException {
        if (this.buf.size() >= this.packageSize) {
            throw new SyncQueueException();
        }
        Hashtable<String, SyncCommand> oSet = this.buf.get(o.getTo());
        if (oSet == null) {
            oSet = new Hashtable();
        }
        oSet.put(o.getObject().toString(), o);
        this.buf.put(o.getTo(), oSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncCommand[] getAll() {
        ArrayList<SyncCommand> commands = new ArrayList<SyncCommand>();
        Hashtable<String, Hashtable<String, SyncCommand>> hashtable = this.buf;
        synchronized (hashtable) {
            for (Hashtable<String, SyncCommand> commandsToAnNode : this.buf.values()) {
                commands.addAll(commandsToAnNode.values());
            }
        }
        return commands.toArray(new SyncCommand[0]);
    }

    public SyncCommand[] get(String myname) {
        Hashtable<String, SyncCommand> oSet = this.buf.remove(myname);
        if (oSet == null) {
            return new SyncCommand[0];
        }
        Vector<SyncCommand> dic = new Vector<SyncCommand>(oSet.values());
        return dic.toArray(new SyncCommand[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncCommand[] add(SyncCommand[] o) {
        ArrayList<SyncCommand> rejectedCommands = new ArrayList<SyncCommand>();
        for (int ci = 0; ci < o.length; ++ci) {
            Hashtable<String, Hashtable<String, SyncCommand>> hashtable = this.buf;
            synchronized (hashtable) {
                Iterator<Hashtable<String, SyncCommand>> i = this.buf.values().iterator();
                boolean commandDuplicated = false;
                SyncCommand command = null;
                Hashtable<String, SyncCommand> commands = null;
                while (i.hasNext()) {
                    commands = i.next();
                    command = commands.get(o[ci].getObject().toString());
                    if (command == null) continue;
                    commandDuplicated = true;
                    break;
                }
                if (commandDuplicated) {
                    switch (o[ci].getType()) {
                        case 1: 
                        case 3: {
                            o[ci].reverse();
                            String from = o[ci].getFrom();
                            o[ci].setTo(from);
                            rejectedCommands.add(o[ci]);
                            break;
                        }
                        case -3: 
                        case -1: {
                            commands.remove(o[ci].getObject().toString());
                            break;
                        }
                    }
                } else {
                    Hashtable<String, SyncCommand> h = this.buf.get(o[ci].getTo());
                    if (h == null) {
                        h = new Hashtable();
                    }
                    h.put(o[ci].getObject().toString(), o[ci]);
                    this.buf.put(o[ci].getTo(), h);
                }
                continue;
            }
        }
        return rejectedCommands.toArray(new SyncCommand[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SyncCommand command) {
        Hashtable<String, Hashtable<String, SyncCommand>> hashtable = this.buf;
        synchronized (hashtable) {
            Hashtable<String, SyncCommand> oSet = this.buf.remove(command.getTo());
            if (oSet != null) {
                oSet.remove(command.getObject().toString());
                this.buf.put(command.getTo(), oSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String nk) {
        Hashtable<String, Hashtable<String, SyncCommand>> hashtable = this.buf;
        synchronized (hashtable) {
            Hashtable<String, SyncCommand> commandsOfTheNode = this.buf.get(nk);
            if (commandsOfTheNode != null) {
                commandsOfTheNode.clear();
                this.buf.remove(commandsOfTheNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable<String, Hashtable<String, SyncCommand>> hashtable = this.buf;
        synchronized (hashtable) {
            for (Hashtable<String, SyncCommand> h : this.buf.values()) {
                h.clear();
            }
            this.buf.clear();
        }
    }
}

