/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsync;

import java.io.Serializable;

public class SyncCommand
implements Serializable {
    private static final long serialVersionUID = 1797515535883166902L;
    public static final int COMMAND_LOCK = 1;
    public static final int COMMAND_UNLOCK = -1;
    public static final int COMMAND_FORWARD_URL = 3;
    public static final int COMMAND_UNFORWARD_URL = -3;
    public static final int COMMAND_SHUTDOWN = 255;
    private Object _o = null;
    private int _commandType = 0;
    private String _from;
    private String _to;

    public SyncCommand() {
    }

    public SyncCommand(Serializable o, int type, String from, String to) throws IllegalArgumentException {
        if (type != 1 && type != -1 && type != 3 && type != -3 && type != 255) {
            throw new IllegalArgumentException("command type\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.setObject(o);
        this._commandType = type;
        this._to = to;
        this._from = from;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append("SYC_");
        switch (this._commandType) {
            case 1: {
                bf.append("LO");
                break;
            }
            case -1: {
                bf.append("UL");
                break;
            }
            case 3: {
                bf.append("FU");
                break;
            }
            case -3: {
                bf.append("UF");
                break;
            }
            case 255: {
                bf.append("SD");
                break;
            }
            default: {
                bf.append("ND");
            }
        }
        bf.append(this._o.toString());
        return bf.toString();
    }

    public void reverse() {
        this._commandType = 0 - this._commandType;
    }

    public Object getObject() {
        return this._o;
    }

    public void setObject(Serializable o) throws IllegalArgumentException {
        this._o = o;
    }

    public int getType() {
        return this._commandType;
    }

    public void setType(int type) {
        this._commandType = type;
    }

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String from) {
        this._from = from;
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to;
    }
}

