/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsync;

import java.util.TooManyListenersException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.dsync.RSSSyncInterface;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueue;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.dsync.event.DelayedSyncEvent;
import org.logical_paradox.rss.dsync.event.DelayedSyncEventListener;

public class RSSSyncDaemon
extends Thread {
    private static final Log log = LogFactory.getLog(RSSSyncDaemon.class);
    public static final int SYNCD_ERROR_LIMIT = 5;
    private RSSSyncInterface syncIF;
    private RSSSyncConfig syncdConfig;
    private SyncQueue syncq = null;
    protected int errorCount = 0;
    private boolean loop = true;
    private String nodeId;
    private DelayedSyncEventListener eventListener;
    private String parentNodeId;

    public RSSSyncDaemon(RSSSyncConfig conf, RSSSyncInterface si) throws Exception {
        this.syncIF = si;
        this.syncdConfig = conf;
        this.parentNodeId = si.getParentNodeId();
        this.syncq = new SyncQueue(this.syncdConfig.getSyncQueueSize());
        this.nodeId = si.getNodeId();
        this.setDaemon(true);
    }

    public void addListener(DelayedSyncEventListener listener) throws TooManyListenersException {
        if (this.eventListener != null) {
            throw new TooManyListenersException("\u30ea\u30b9\u30ca\u30fc\u306f\u8ffd\u52a0\u3067\u304d\u306a\u3044\u306e\u3067\uff0c\u4e00\u5ea6\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
        }
        this.eventListener = listener;
    }

    public void removeListener() {
        if (this.eventListener != null) {
            this.eventListener = null;
        }
    }

    public void run() {
        this.write("\u9045\u5ef6\u540c\u671f\u30c7\u30fc\u30e2\u30f3\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f");
        try {
            while (this.loop) {
                RSSSyncDaemon.sleep(this.syncdConfig.getSyncInterval());
                SyncCommand[] receivedElements = this.sync();
                if (receivedElements != null) {
                    this.errorCount = 0;
                    this.handleAllEvents(receivedElements);
                    continue;
                }
                if (this.errorCount < 5) continue;
                this.loop = false;
            }
            this.write("\u540c\u671f\u30a8\u30e9\u30fc\u304c\u6307\u5b9a\u56de\u6570\u9023\u7d9a\u3057\u3066\u767a\u751f\u3057\u305f\u305f\u3081\uff0c\u540c\u671f\u30c7\u30fc\u30e2\u30f3\u3092\u505c\u6b62\u3057\u307e\u3059");
            this.done();
        }
        catch (InterruptedException intrexp) {
            this.write("\u540c\u671f\u30c7\u30fc\u30e2\u30f3\u306b\u5bfe\u3059\u308b\u505c\u6b62\u547d\u4ee4\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f");
            this.done();
        }
    }

    protected void write(String ls) {
        log.trace((Object)ls);
    }

    public void shutdown() {
        this.loop = false;
    }

    protected void done() {
        this.write("\u540c\u671f\u30c7\u30fc\u30e2\u30f3\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }

    public void add(SyncCommand command) throws SyncQueueException {
        try {
            if (command.getTo() == null) {
                command.setTo(this.parentNodeId);
            }
            if (command.getFrom() == null) {
                command.setFrom(this.getNodeId());
            }
            this.syncq.add(command);
        }
        catch (Exception e) {
            log.warn((Object)e);
            throw new SyncQueueException(e.getMessage());
        }
    }

    public void remove(SyncCommand command) {
        this.syncq.remove(command);
    }

    public SyncCommand[] sync() {
        SyncCommand[] e = null;
        try {
            this.syncIF.sync(this.syncq.getAll());
            this.syncq.clear();
            e = this.syncIF.getSyncData();
            if (e != null && e.length > 0) {
                this.write(e.length + "\u4ef6\u306e\u540c\u671f\u60c5\u5831\u304c\u7121\u52b9\u5316\u3055\u308c\u307e\u3057\u305f");
            }
        }
        catch (Exception exp) {
            ++this.errorCount;
            this.write("\u540c\u671f\u60c5\u5831\u306e\u9001\u53d7\u4fe1\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:");
            exp.printStackTrace();
        }
        return e;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    protected void handleAllEvents(SyncCommand[] commands) {
        if (this.eventListener == null) {
            return;
        }
        block7: for (int cnt = 0; cnt < commands.length; ++cnt) {
            DelayedSyncEvent eventObject = new DelayedSyncEvent(this, commands[cnt]);
            switch (commands[cnt].getType()) {
                case 1: {
                    this.eventListener.onLock(eventObject);
                    continue block7;
                }
                case -1: {
                    this.eventListener.onUnlock(eventObject);
                    continue block7;
                }
                case 3: {
                    this.eventListener.onForwardURL(eventObject);
                    continue block7;
                }
                case -3: {
                    this.eventListener.onUnforwardURL(eventObject);
                    continue block7;
                }
                case 255: {
                    this.eventListener.onShutdown(eventObject);
                    continue block7;
                }
                default: {
                    this.write("\u6307\u5b9a\u3055\u308c\u305f\u30b3\u30de\u30f3\u30c9\u304c\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093: " + eventObject.getCommand().toString());
                }
            }
        }
    }
}

