/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr.routing;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsr.routing.RoutingAlgorithm;
import org.logical_paradox.rss.dsr.routing.RoutingAlgorithmFactory;
import org.logical_paradox.rss.dsr.routing.metrics.MetricCountException;
import org.logical_paradox.rss.dsr.routing.metrics.MetricCountingAlgorithmFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private static final Log log = LogFactory.getLog(Node.class);
    private String nodeId;
    private final RSSDistributedServiceRegistry dsr;
    private ArrayList<Node> relativeNodes = new ArrayList();
    private final RoutingAlgorithm algorithm;

    public Node(RSSDistributedServiceRegistry dsr_, String nn) {
        this.nodeId = nn;
        this.dsr = dsr_;
        this.algorithm = RoutingAlgorithmFactory.getDefaultAlgorithm(this);
    }

    public RSSDistributedServiceRegistry getRegistry() {
        return this.dsr;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        return node.nodeId.equals(this.nodeId);
    }

    public void disconnect() {
        this.algorithm.notifyDisconnect();
    }

    public boolean contains(Node node) {
        return this.relativeNodes.contains(node);
    }

    public boolean isHoldByBuddies() {
        Iterator<Node> it = this.iteratorRelativeNodes();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.contains(this)) continue;
            return false;
        }
        return true;
    }

    public boolean hug(Node node) {
        return this.algorithm.hug(node);
    }

    public void add(Node node) {
        try {
            if (this.contains(node)) {
                log.warn((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u91cd\u8907\u3057\u3066\u767b\u9332\u3055\u308c\u307e\u305b\u3093"));
                return;
            }
            this.getRegistry().bind(1, node.getNodeId(), node.getRegistry());
            this.relativeNodes.add(node);
            log.info((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u7d50\u5408\u3057\u307e\u3057\u305f"));
        }
        catch (RemoteException e) {
            log.warn((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u306e\u7d50\u5408\u306b\u5931\u6557"), (Throwable)e);
        }
    }

    public void addAll(Collection<Node> nodes) {
        this.relativeNodes.addAll(nodes);
    }

    public void remove(Node node) {
        try {
            this.getRegistry().unbind(1, node.getNodeId());
            this.relativeNodes.remove(node);
            log.info((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u306e\u7d50\u5408\u3092\u89e3\u9664\u3057\u307e\u3057\u305f"));
        }
        catch (RemoteException e) {
            log.warn((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u306e\u7d50\u5408\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f"), (Throwable)e);
        }
    }

    public void clear() {
        this.relativeNodes.clear();
    }

    public double distanceFrom(Node node) {
        int links = 5 - node.getRelativeNodes().size();
        if (links < 0) {
            links = 0;
        }
        try {
            double distance = MetricCountingAlgorithmFactory.getAlgorithm().count(node);
            log.trace((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u306e\u8ad6\u7406\u7684\u8ddd\u96e2 = " + distance));
            return distance + (double)(links * 100);
        }
        catch (MetricCountException e) {
            log.warn((Object)("\u30ce\u30fc\u30c9[" + node.getNodeId() + "]\u3068\u306e\u30e1\u30c8\u30ea\u30c3\u30af\u8a08\u6e2c\u306b\u5931\u6557"), (Throwable)e);
            return 0.0;
        }
    }

    public Iterator<Node> iteratorRelativeNodes() {
        return this.relativeNodes.iterator();
    }

    public List<Node> getRelativeNodes() {
        return this.getRelativeNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getRelativeNodes(boolean refresh) {
        if (refresh) {
            try {
                String[] services = this.getRegistry().services(1);
                ArrayList<Node> arrayList = this.relativeNodes;
                synchronized (arrayList) {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (int i = 0; i < services.length; ++i) {
                        try {
                            RSSDistributedServiceRegistry dsr = (RSSDistributedServiceRegistry)this.getRegistry().getService(services[i], 1);
                            if (dsr != null) {
                                nodes.add(new Node(dsr, dsr.getName()));
                                continue;
                            }
                            log.warn((Object)("DSR[" + services[i] + "]\u306f\u767a\u898b\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f."));
                            continue;
                        }
                        catch (RemoteException e) {
                            log.warn((Object)("DSR[" + services[i] + "]\u3068\u306e\u901a\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e\u3053\u306eDSR\u3092\u7121\u8996\u3057\u307e\u3059:"), (Throwable)e);
                        }
                    }
                    this.relativeNodes.clear();
                    this.relativeNodes.addAll(nodes);
                }
            }
            catch (RemoteException e) {
                log.error((Object)("DSR[" + this.getNodeId() + "]\u3068\u306e\u901a\u4fe1\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e\u30ce\u30fc\u30c9\u95a2\u9023\u60c5\u5831\u306f\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093:"), (Throwable)e);
            }
        }
        return this.relativeNodes;
    }

    public void configure() {
        this.algorithm.configure();
    }
}

