/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceList {
    protected final Hashtable<String, Service> list = new Hashtable();
    protected final ServiceBindingAlgorithm bindingAlgorithm;

    public ServiceList(ServiceBindingAlgorithm ba) {
        this.bindingAlgorithm = ba;
    }

    public void add(String name, Service stub) {
        this.list.put(name, stub);
    }

    public void remove(String name) {
        this.list.remove(name);
    }

    public Iterator<String> iterator() {
        return this.list.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] serviceNames() {
        Hashtable<String, Service> hashtable = this.list;
        synchronized (hashtable) {
            return this.list.keySet().toArray(new String[0]);
        }
    }

    public boolean contains(String serviceName) {
        return this.list.containsKey(serviceName);
    }

    public Service getService() {
        String serviceName = this.bindingAlgorithm.getService(this);
        if (serviceName != null) {
            return this.list.get(serviceName);
        }
        return null;
    }

    public Service getService(String serviceName) {
        Service service = this.list.get(serviceName);
        return service;
    }

    public Collection<Service> values() {
        return this.list.values();
    }
}

