/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.mysql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;
import org.logical_paradox.rss.rcm.accessor.simple.VirtualQueueServer;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

public class DbmysqlContentsAccessor
implements ContentsAccessor {
    private static final Log log = LogFactory.getLog(DbmysqlContentsAccessor.class);
    private String dsruri;
    private boolean activeFlag = false;
    private VirtualQueueServer queue = null;
    private static DataFilter dataFilter = null;
    private Connection con;
    private PreparedStatement pstmt;
    private ConnectionValidator validator;
    public static final String JDBC_DRIVER_CLASSNAME = "com.mysql.jdbc.Driver";
    public static final long CONNECTION_WATCH_INTERVAL = 120000L;

    public void init(String initparam) {
        this.open(initparam);
    }

    public synchronized void open(String openstr) {
        if (this.isActive()) {
            return;
        }
        if (openstr == null || openstr.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.activeFlag = true;
            this.queue = new VirtualQueueServer(this.dsruri);
            Class.forName(JDBC_DRIVER_CLASSNAME);
            this.con = DriverManager.getConnection(openstr);
            String sql = "select * from contents where mkey=?";
            this.pstmt = this.con.prepareStatement(sql);
            this.validator = new ConnectionValidator(120000L);
            ConnectionValidation cv = new ConnectionValidation(this.con, "select count(*) from contents");
            this.validator.add(cv);
            this.validator.start();
        }
        catch (Exception e) {
            if (this.con != null) {
                DbUtils.closeConnection((Connection)this.con);
                this.con = null;
            }
            if (this.pstmt != null) {
                DbUtils.closeStatement((Statement)this.pstmt);
                this.pstmt = null;
            }
            log.error((Object)("\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)e)));
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void regist(WebContents contents) {
        ResultSet rs;
        Statement st;
        block15: {
            String sql = "insert into contents values(null,?,?,?,?,?)";
            String url = contents.getLocation();
            String document = contents.getDocument();
            byte[] barray = new byte[]{};
            try {
                barray = dataFilter.compressContents(document.getBytes());
            }
            catch (Exception e1) {
                log.warn((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)e1)), (Throwable)e1);
                return;
            }
            ByteArrayInputStream bi = new ByteArrayInputStream(barray);
            String sitename = "site site";
            String title = "document title";
            PreparedStatement updateStmt = null;
            st = null;
            rs = null;
            try {
                String digest = dataFilter.filterURL(url);
                updateStmt = this.con.prepareStatement(sql);
                updateStmt.setString(1, digest);
                updateStmt.setString(2, sitename);
                updateStmt.setString(3, title);
                updateStmt.setString(4, url);
                updateStmt.setBinaryStream(5, (InputStream)bi, barray.length);
                updateStmt.executeUpdate();
                updateStmt.close();
                sql = "select last_insert_id() as did from contents";
                st = this.con.createStatement();
                rs = st.executeQuery(sql);
                if (rs.next()) {
                    long did = rs.getLong("did");
                    String documentId = DocumentIdGenerator.getDocumentId((long)did, (String)digest);
                    this.queue.enqueue(documentId);
                } else {
                    log.warn((Object)"\u4f55\u3089\u304b\u306e\u539f\u56e0\u3067\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u756a\u53f7\u3092\u767a\u756a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
                }
                if (updateStmt == null) break block15;
            }
            catch (Exception e) {
                block16: {
                    try {
                        log.warn((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)e)), (Throwable)e);
                        if (updateStmt == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (updateStmt != null) {
                            DbUtils.closeStatement(updateStmt);
                        }
                        if (rs != null) {
                            DbUtils.closeResultSet(rs);
                        }
                        if (st != null) {
                            DbUtils.closeStatement(st);
                        }
                        throw throwable;
                    }
                    DbUtils.closeStatement((Statement)updateStmt);
                }
                if (rs != null) {
                    DbUtils.closeResultSet(rs);
                }
                if (st != null) {
                    DbUtils.closeStatement(st);
                }
            }
            DbUtils.closeStatement((Statement)updateStmt);
        }
        if (rs != null) {
            DbUtils.closeResultSet((ResultSet)rs);
        }
        if (st != null) {
            DbUtils.closeStatement((Statement)st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregist(String url) {
        if (!this.isActive() || url == null || url.trim().length() == 0) {
            throw new IllegalStateException();
        }
        String sql = "delete from contents where mkey=?";
        PreparedStatement deleteStmt = null;
        Connection con = null;
        try {
            deleteStmt = con.prepareStatement(sql);
            deleteStmt.setString(1, url);
            deleteStmt.executeUpdate(sql);
        }
        catch (SQLException se) {
            log.warn((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + url + "]: " + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
        }
        finally {
            if (deleteStmt != null) {
                DbUtils.closeStatement((Statement)deleteStmt);
                deleteStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistAll() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        String sql = "delete from contents";
        Statement st = null;
        Connection con = null;
        try {
            st = con.createStatement();
            st.executeUpdate(sql);
        }
        catch (SQLException se) {
            log.warn((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
        }
        finally {
            if (st != null) {
                DbUtils.closeStatement((Statement)st);
                st = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String find(String url) {
        if (!this.isActive() || url == null || url.trim().length() == 0) {
            throw new IllegalStateException();
        }
        String contents = null;
        ResultSet rs = null;
        try {
            this.pstmt.setString(1, url);
            rs = this.pstmt.executeQuery();
            if (rs.next()) {
                contents = rs.getString(1);
            }
            if (rs == null) return contents;
        }
        catch (SQLException se) {
            try {
                log.warn((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + url + "]:" + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
                if (rs == null) return contents;
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                DbUtils.closeResultSet(rs);
                rs = null;
                throw throwable;
            }
            DbUtils.closeResultSet((ResultSet)rs);
            return contents;
        }
        DbUtils.closeResultSet((ResultSet)rs);
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (!this.isActive()) {
            throw new IllegalStateException("connector has already been closed");
        }
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException e) {
            log.warn((Object)("\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u30af\u30ed\u30fc\u30ba\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)e)), (Throwable)e);
        }
        finally {
            if (this.con != null) {
                try {
                    this.con.close();
                }
                catch (SQLException e) {
                    log.warn((Object)("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u7d42\u4e86\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)e)), (Throwable)e);
                }
                this.con = null;
            }
        }
        this.activeFlag = false;
    }

    protected boolean isActive() {
        return this.activeFlag;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDSRURI(String uri) {
        this.dsruri = uri;
    }

    static {
        dataFilter = DataFilterFactory.getFilter((int)1);
    }
}

