/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.rss.util.DocumentIdGenerator;

public class MySQLInvertedIndexRegistrar
extends Thread {
    private static final Log log = LogFactory.getLog(MySQLInvertedIndexRegistrar.class);
    private HashMap<Long, HashMap<String, String>> queue = new HashMap();
    private final Connection con;
    private final Base64 base64 = new Base64();

    public MySQLInvertedIndexRegistrar(Connection c) {
        this.con = c;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                HashMap<Long, HashMap<String, String>> hashMap = this.queue;
                synchronized (hashMap) {
                    while (this.queue.size() == 0) {
                        this.queue.wait();
                    }
                    try {
                        this.register();
                    }
                    catch (Exception iae) {
                        log.warn((Object)"\u7d22\u5f15\u8a9e\u306e\u767b\u9332\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:", (Throwable)iae);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(String digest, Term[] term) throws IndexAccessException {
        HashMap<Long, HashMap<String, String>> hashMap = this.queue;
        synchronized (hashMap) {
            long recordNo = DocumentIdGenerator.getDocumentNo((String)digest);
            Long queueId = new Long(recordNo);
            HashMap<String, String> recordQueue = this.queue.get(queueId);
            if (recordQueue == null) {
                recordQueue = new HashMap();
            }
            for (int i = 0; i < term.length; ++i) {
                String locations = recordQueue.get(term);
                if (locations == null) {
                    locations = "";
                }
                for (Integer offset : term[i]) {
                    if (!StringUtils.isEmpty((String)locations)) {
                        locations = locations + ",";
                    }
                    locations = locations + offset;
                    recordQueue.put(term[i].getTerm(), locations);
                }
            }
            this.queue.put(queueId, recordQueue);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register() throws IndexAccessException {
        HashMap map = null;
        HashMap<Long, HashMap<String, String>> hashMap = this.queue;
        synchronized (hashMap) {
            map = (HashMap)this.queue.clone();
            for (Long qid : this.queue.keySet()) {
                HashMap<String, String> rq = this.queue.get(qid);
                if (rq == null) continue;
                map.put(qid, rq.clone());
                rq.clear();
            }
            this.queue.clear();
        }
        for (Long qid : map.keySet()) {
            HashMap rq = (HashMap)map.get(qid);
            if (rq == null || rq.size() == 0) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("insert into inverted_index values");
            int length = rq.keySet().size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("(?,?,?)");
            }
            PreparedStatement pstmt = null;
            try {
                pstmt = this.con.prepareStatement(sb.toString());
            }
            catch (SQLException se) {
                DbUtils.closeStatement(pstmt);
                pstmt = null;
                log.error((Object)("\u767b\u9332\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
                return;
            }
            try {
                int paramCnt = 1;
                for (String key : rq.keySet()) {
                    String value = (String)rq.get(key);
                    String term = new String(this.base64.encode(key.getBytes()));
                    pstmt.setString(paramCnt++, term);
                    pstmt.setLong(paramCnt++, qid);
                    pstmt.setString(paramCnt++, value);
                }
                pstmt.executeUpdate();
                pstmt.close();
                rq.clear();
            }
            catch (Exception se) {
                log.warn((Object)("\u767b\u9332\u306b\u5931\u6557: " + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
            }
            finally {
                DbUtils.closeStatement((Statement)pstmt);
            }
        }
        map.clear();
    }

    protected void shutdown() {
        this.interrupt();
    }
}

