/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.koike.rss.index.MySQLInterfaceConstant;
import org.logical_paradox.koike.rss.index.MySQLInvertedIndexRegistrar;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;

public class MySQLIndexAccessor
implements IndexAccessor,
MySQLInterfaceConstant {
    private static final Log log = LogFactory.getLog(MySQLIndexAccessor.class);
    private PreparedStatement removeStatement;
    private PreparedStatement searchStatement;
    private Connection con;
    private ConnectionValidator validator;
    private MySQLInvertedIndexRegistrar registrar;
    private final Base64 base64 = new Base64();

    public MySQLIndexAccessor(ConnectionValidator cv) throws Exception {
        this.validator = cv;
        this.init();
    }

    protected void init() throws Exception {
        ResourceBundle rb = ResourceBundle.getBundle("mysql");
        String jdbcDriverClass = rb.getString("jdbc.driver.class");
        String connstr = rb.getString("index.connect.str");
        try {
            Class.forName(jdbcDriverClass);
            this.con = DriverManager.getConnection(connstr);
            String removeSql = rb.getString("index.remove.sql");
            String searchSql = rb.getString("index.search.sql");
            this.removeStatement = this.con.prepareStatement(removeSql);
            this.searchStatement = this.con.prepareStatement(searchSql);
            ConnectionValidation validation = new ConnectionValidation(this.con, "select count(*) from inverted_index");
            this.validator.add(validation);
            this.registrar = new MySQLInvertedIndexRegistrar(this.con);
            this.registrar.start();
        }
        catch (Exception e) {
            DbUtils.closeStatement((Statement)this.removeStatement);
            DbUtils.closeStatement((Statement)this.searchStatement);
            DbUtils.closeConnection((Connection)this.con);
            log.error((Object)("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30a2\u30af\u30bb\u30b9\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u521d\u671f\u5316\u306b\u5931\u6557:" + ExceptionUtils.stackTraceToString((Exception)e)), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.con == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IndexAccessException {
        if (this.registrar != null) {
            this.registrar.shutdown();
            try {
                this.registrar.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.registrar = null;
            }
        }
    }

    public void addTerm(String digest, Term[] term) throws IndexAccessException {
        this.registrar.add(digest, term);
    }

    public Object removeTerm(String key) throws IndexAccessException {
        try {
            this.removeStatement.setString(1, key);
            this.removeStatement.executeUpdate();
            return null;
        }
        catch (SQLException se) {
            log.warn((Object)("\u7d22\u5f15\u8a9e\u306e\u524a\u9664\u306b\u5931\u6557:" + ExceptionUtils.stackTraceToString((Exception)se)), (Throwable)se);
            throw new IndexAccessException((Exception)se);
        }
    }

    public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
        KoikeIndexResultSet kirs = new KoikeIndexResultSet();
        double begin = System.currentTimeMillis();
        ResultSet rs = null;
        try {
            String term = new String(this.base64.encode(key.getBytes()));
            this.searchStatement.setString(1, term);
            rs = this.searchStatement.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
                long docno = rs.getLong("docno");
                String location = rs.getString("location");
                if (StringUtils.isEmpty((String)location)) continue;
                kirs = this.createInvertedIndex(kirs, (int)docno, location);
            }
            log.trace((Object)("term [" + key + "] is found in [" + cnt + "] rows."));
        }
        catch (Exception e) {
            try {
                log.warn((Object)("\u7d22\u5f15\u8a9e\u306e\u691c\u7d22\u306b\u5931\u6557:" + ExceptionUtils.stackTraceToString((Exception)e)), (Throwable)e);
                throw new IndexAccessException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DbUtils.closeResultSet((ResultSet)rs);
        double fin = System.currentTimeMillis();
        log.trace((Object)("\u691c\u7d22\u6642\u9593: " + (fin - begin) / 1000.0 + "sec."));
        return kirs;
    }

    protected KoikeIndexResultSet createInvertedIndex(KoikeIndexResultSet rs, int docno, String value) {
        if (rs == null) {
            rs = new KoikeIndexResultSet();
        }
        String nodeId = "";
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            int pos = Integer.parseInt(values[i]);
            int blkno = docno / 64;
            long documents = 1L << (int)((long)(docno - blkno * 64));
            InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
            if (iidx != null) {
                documents |= iidx.getDocumentAvailability();
            } else {
                iidx = new InvertedIndex(nodeId, blkno, 0L);
            }
            iidx.setDocumentAvailability(documents, false);
            iidx.addLocation(new Location(nodeId, docno, pos));
            rs.addInvertedIndex(iidx);
        }
        return rs;
    }
}

