/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.index;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ResourceBundle;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.koike.rss.index.MySQLInterfaceConstant;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

public class MySQLDocumentAccessor
implements DocumentAccessor,
MySQLInterfaceConstant {
    private final ResourceBundle resource;
    private DataFilter filter;
    private Connection con;
    private ConnectionValidator validator;
    private PreparedStatement pstmt;

    public MySQLDocumentAccessor(ConnectionValidator vc) {
        this.validator = vc;
        this.resource = ResourceBundle.getBundle("mysql");
        try {
            String jdbcDriverClass = this.resource.getString("jdbc.driver.class");
            String connstr = this.resource.getString("document.connect.str");
            String sql = this.resource.getString("document.search.sql");
            Class.forName(jdbcDriverClass);
            this.con = DriverManager.getConnection(connstr);
            this.pstmt = this.con.prepareStatement(sql);
            this.filter = DataFilterFactory.getFilter((int)1);
            ConnectionValidation validation = new ConnectionValidation(this.con, "select count(*) from contents");
            this.validator.add(validation);
        }
        catch (Exception e) {
            this.tearDown();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(String key) throws Exception {
        long docid = DocumentIdGenerator.getDocumentNo((String)key);
        Document document = null;
        MySQLDocumentAccessor mySQLDocumentAccessor = this;
        synchronized (mySQLDocumentAccessor) {
            ResultSet rs = null;
            try {
                this.pstmt.setLong(1, docid);
                rs = this.pstmt.executeQuery();
                if (rs.next()) {
                    String sitename = rs.getString("sitename");
                    String title = rs.getString("title");
                    String url = rs.getString("url");
                    Blob blob = rs.getBlob("contents");
                    long length = blob.length();
                    byte[] decompressedContents = this.filter.decompressContents(blob.getBytes(1L, (int)length));
                    document = new Document();
                    document.setDocument(new String(decompressedContents));
                    ContentsAttribute attr = new ContentsAttribute();
                    attr.setSitename(sitename);
                    attr.setTitle(title);
                    attr.setUrl(url);
                    document.setAttribute((Serializable)attr);
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeResultSet(rs);
                throw throwable;
            }
            DbUtils.closeResultSet((ResultSet)rs);
        }
        return document;
    }

    public void close() throws Exception {
        this.tearDown();
    }

    public boolean isClosed() {
        return this.con != null;
    }

    protected synchronized void tearDown() {
        DbUtils.closeStatement((Statement)this.pstmt);
        DbUtils.closeConnection((Connection)this.con);
    }
}

