/*
 * $Id: FIFORoutingAlgorithm.java,v 1.2 2006/01/27 16:39:03 rampil Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.router.algorithm;
import java.net.MalformedURLException;
import java.util.Iterator;

import org.logical_paradox.rss.http.URLPool;

/**
 * FIFORoutingAlgorithm
 * TCgT̂߂̕WIȃASY<br>
 * lȂŁCFIFOŕԂ<br>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class FIFORoutingAlgorithm extends RoutingAlgorithm {
	/**
	 * RXgN^D
	 */
	public FIFORoutingAlgorithm() {
		super();
	}

	/**
	 * ASŶ̖ԂD
	 * @return ASY̖
	 */
	public String getAlgorithmName() {
		return "Simple Fast In Fast Out Routing Algorithm";
	}

	/**
	 * 1肷邽߂̃ASY()
	 * @param urls URLv[
	 * @return œKURL
	 */
	public String nextURL(URLPool urls) {
		String rc = null;

		synchronized(urls) {
			boolean exitf = true;
			do {
				if(urls.size() == 0) {
					// Ȃ
					rc = null;
					exitf = false;
				} else {
					// URL̃v[URL1擾
					// OԂ̂Ƃ(̏ꍇ)ႤTCgURLԂ
					String[] domains = urls.domains();
					int p = (int)(Math.random() * domains.length);
					Iterator i = urls.getURLIterator(domains[p]);
					if(i == null) {
						return null;
					}
					rc = (String)i.next();
					try {
						urls.remove(rc);
					} catch(MalformedURLException e) {
					}

					if(history.isTraced(rc) == false) {
						// ܂g[XĂȂURLꍇ
						// Tɒǉ
						history.add(rc);

						exitf = false;
					}
				}
			} while(exitf == true);
		}

		return rc;
	}
}
