/*
 * $Id: SiteLockMgr.java,v 1.4 2006/01/27 16:39:04 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.router;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * SiteLockMgr
 * TCgbN󋵂ǗNX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class SiteLockMgr {
	/** 5ȏANZX̓bNIuWFNg͉ */
	public static final int SITELOCK_EXPIRE = 1000 * 60 * 5;

	/** bN */
	private Hashtable<String, SiteLock> locks = new Hashtable<String, SiteLock>();
	/** TCgbN̗L */
	private long siteLockExpire;

	/**
	 * RXgN^D
	 */
	public SiteLockMgr() {
		siteLockExpire = SITELOCK_EXPIRE;
	}
	/**
	 * RXgN^D
	 * @param expire TCgbN̗L(msec)
	 */
	public SiteLockMgr(long expire) {
		siteLockExpire = expire;
	}

	/**
	 * bNǉ
	 * bNǉ邱ƂłꍇtrueCsꍇfalseԂ
	 */
	public boolean lock(SiteLock l) {
		boolean rc = true;

		synchronized(locks) {
			SiteLock o = locks.get(getSiteKey(l));
			if(o != null) {
				rc = false;
			} else {
				locks.put(getSiteKey(l), l);
				rc = true;
			}
		}

		return rc;
	}

	/**
	 * bN
	 */
	public void unlock(SiteLock l) {
		synchronized(locks) {
			SiteLock o = locks.get(getSiteKey(l));
			if(o == null) {
				return;
			}
			locks.remove(getSiteKey(l));
		}
	}

	/**
	 * wTCgbNĂ郍{bgIDԂ
	 * NbNĂȂꍇnullԂ
	 */
	public String getLockOwnerId(SiteLock l) {
		String owner = null;
		return owner;
	}

	/**
	 * wID̒Tm[hۗLĂ郍bN̐Ԃ
	 */
	public int numOfMyLocks(String robotId) {
		Hashtable p = null;
		synchronized(locks) {
			p = (Hashtable)locks.clone();
		}

		Enumeration e = p.elements();
		int num = 0;

		while(e.hasMoreElements()) {
			SiteLock i = (SiteLock)e.nextElement();
			if(i.getRobotId().equals(robotId)) {
				num++;
			}
		}

		p = null;

		return num;
	}

	/**
	 * w肳ꂽID̃{bgbNĂTCgԂ
	 * bNĂȂꍇnullԂ
	 */
	public String[] getLockingSitesByOwner(String id) {
		Vector<SiteLock> ar = new Vector<SiteLock>();
		Hashtable p = null;

		synchronized(locks) {
			p = (Hashtable)locks.clone();
		}

		Enumeration e = p.elements();
		while(e.hasMoreElements()) {
			SiteLock l = (SiteLock)e.nextElement();
			if(l.getRobotId().equals(id)) {
				ar.addElement(l);
			}
		}

		return (String[])ar.toArray(new String[1]);
	}

	/**
	 * w肳ꂽbN擾
	 * w肳Tm[hIDŎ擾łȂꍇnull
	 */
	public SiteLock findLock(String dn, String rid) {
		String skey = new String(dn);
		SiteLock l = null;

		synchronized(locks) {
			l = locks.get(skey);
		}

		if(l != null && l.getRobotId().equals(rid)) {
			// bNIuWFNg̓tXV
			// ꂽƂƂ́CNKvƂĂƂƂȂ̂ŁD
			l.touch();

			// ̃TCg̃bN̕ێ҂͎
			return l;
		} else {
			// ȊObNĂ邩C邢̓bN݂̂Ȃꍇ
			return null;
		}
	}

	/**
	 * TCgbNǗp̃L[𐶐
	 */
	protected String getSiteKey(SiteLock l) {
		return l.getSiteName();
	}

	/**
	 * bÑL[Ԃ
	 * łL[Ƃ́ChĈ
	 */
	public String[] getSiteNames() {
		Vector<String> v = new Vector<String>();
		synchronized(locks) {
			Enumeration e = locks.keys();
			while(e.hasMoreElements()) {
				v.addElement(e.nextElement().toString());
			}
		}

		return (String[])v.toArray(new String[1]);
	}

	/**
	 * w肳ꂽTm[hۗLSẴbN
	 * @param robotId Tm[hID
	 * @return ꂽbÑXg
	 */
	public void releaseAll(String robotId) {
		synchronized(locks) {
			Enumeration e = locks.elements();
			while(e.hasMoreElements()) {
				SiteLock l = (SiteLock)e.nextElement();
				if(l.getRobotId().equals(robotId)) {
					// w肳ꂽTm[hIDۗ̕L郍bN̏ꍇ͍폜tO𗧂Ă
					// ۂɂ́CXbhKȃ^C~Oŏ
					l.markGC();
				}
			}
		}
	}

	/**
	 * TCgbÑS~
	 * S~̃XgzŕԂ
	 * @return S~̃Xg
	 */
	public SiteLock[] gc() {
		Vector<SiteLock> removedLockObjs = new Vector<SiteLock>();

		synchronized(locks) {
			String[] keys = getSiteNames();
			for(String key : keys) {
				if(key == null) {
					continue;
				}

				SiteLock l = locks.get(key);
				if(l != null) {
					// ΂炭ANZXȂ悤ł΁CbNIuWFNg\Ԃɐݒ肷
					if(siteLockExpire > 0 && Calendar.getInstance().getTimeInMillis() - l.getLastAccessTime() >= siteLockExpire) {
						l.markGC();
					}
				}
				if(l != null && l.isBroken() == true) {
					// 폜
					removedLockObjs.addElement(locks.remove(key));
				}
			}
		}

		return removedLockObjs.toArray(new SiteLock[0]);
	}
}
