/*
 * $Id: RSSWebSpiderConfig.java,v 1.4 2006/01/27 16:39:04 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.robot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

/**
 * RSSWebSpiderConfig
 * RSS WebTVXe̐ݒēNX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class RSSWebSpiderConfig extends RSSConfig {
	/** User-Agent */
	private String cfgHttpUserAgent = "RSS-agent/1b (http://www.logical-paradox.org/)";
	/** T̕x */
	private int cfgAgentsPerRobot = 1;
	/** ڑ^CAEgb(msec) */
	private int cfgAgentConnectionTimeoutSec = 30000;
	/** fobOOo̓XCb`(true:o͂ / false:Ȃ) */
	private boolean cfgRobotSwDebugTraceLog = false;
	/** Oo̓XCb`(true:o͂ / false:Ȃ) */
	private boolean cfgRobotSwRunLog = false;
	/** fobOOt@C */
	private String cfgDebugTraceLogFilename = "rss.debug.trace.log";
	/** Ot@C */
	private String cfgRobotRunLogFilename = "rsswebspider.run.log";
	/** 舵Content-TypẽXg */
	private String[] cfgAllowedContentType;

	/**
	 * RXgN^
	 * @param RtBOt@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException RtBOt@C̓es
	 */
	public RSSWebSpiderConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
		cfgAllowedContentType = null;
		String errmsg = checkResourceVariables();
		if(errmsg != null) {
			throw new RSSIllegalConfigException(errmsg);
		}
	}

	public String getHttpUserAgent() {
		return cfgHttpUserAgent;
	}
	public int getAgentsPerRobot() {
		return cfgAgentsPerRobot;
	}
	public int getAgentConnectionTimeoutSec() {
		return cfgAgentConnectionTimeoutSec;
	}
	public boolean getRobotSwDebugTraceLog() {
		return cfgRobotSwDebugTraceLog;
	}
	public boolean getRobotSwRunLog() {
		return cfgRobotSwRunLog;
	}
	public String getDebugTraceLogFilename() {
		return cfgDebugTraceLogFilename;
	}
	public String getRobotRunLogFilename() {
		return cfgRobotRunLogFilename;
	}
	public String[] getAllowedContentType() {
		return cfgAllowedContentType;
	}

	public boolean isEnabledContentType(String ct) {
		if(cfgAllowedContentType == null || cfgAllowedContentType.length == 0) {
			// `ĂȂꍇCSẴRecWΏۂɂȂ
			return true;
		}

		for(int i = 0; i < cfgAllowedContentType.length; i++) {
			if(ct.indexOf(cfgAllowedContentType[i]) >= 0) {
				return true;			// 
			}
		}

		return false;
	}

	/**
	 * p[^mF\bh
	 */
	@Override
	protected String checkResourceVariables() {
		String errmsg = "";

		if(getProperty("HTTP_USER_AGENT") != null) {
			cfgHttpUserAgent = getProperty("HTTP_USER_AGENT");
		}

		try {
			cfgAgentsPerRobot = getPropertyAsInt("AGENTS_PER_ROBOT");
		} catch(RSSValueFormatException vfe) {
			errmsg += "AGENTS_PER_ROBOT̒lsł\n";
		} catch(RSSNullValueException ne) {}

		try {
			cfgAgentConnectionTimeoutSec = getPropertyAsInt("AGENT_CONNECTION_TIMEOUT_SEC");
		} catch(RSSValueFormatException vfe) {
			errmsg += "AGENT_CONNECTION_TIMEOUT_SEC̒lsł";
		} catch(RSSNullValueException ne) {}

		try {
			cfgRobotSwDebugTraceLog = getPropertyAsBool("ROBOT_SW_DEBUG_TRACE_LOG");
		} catch(RSSValueFormatException vfe) {
			errmsg += "ROBOT_SW_DEBUG_TRACE_LOG̒lsł";
		} catch(RSSNullValueException ne) {}

		try {
			cfgRobotSwRunLog = getPropertyAsBool("ROBOT_SW_RUNLOG");
		} catch(RSSValueFormatException vfe) {
			errmsg += "ROBOT_SW_RUNLOG̒lsł";
		} catch(RSSNullValueException ne) {}

		cfgDebugTraceLogFilename = getProperty("DEBUG_TRACE_LOG_FILENAME");
		cfgRobotRunLogFilename = getProperty("ROBOT_RUNLOG_FILENAME");

		String contentTypes = getProperty("ALLOWED_CONTENT_TYPE");
		if(contentTypes == null || contentTypes.trim().length() == 0) {
			cfgAllowedContentType = new String[0];
		} else {
			ArrayList<String> types = new ArrayList<String>();
			StringTokenizer t = new StringTokenizer(contentTypes.trim(), ",");
			while(t.hasMoreTokens()) {
				types.add(t.nextToken().trim());
			}

			cfgAllowedContentType = (String[])types.toArray(new String[0]);
		}

		if(errmsg.trim().length() > 0) {
			return errmsg;
		} else {
			return null;
		}
	}
}

// end of RSSWebSpiderConfig.java
