/*
 * $Id: RSSWebNavigator.java,v 1.18 2006/02/06 15:32:50 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.robot;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.net.IPAddressRangeSet;
import org.logical_paradox.common.net.IPAddressRangeSetFactory;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.RSSConstant;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSProperties;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.HREFCollector;
import org.logical_paradox.rss.http.NoIndexException;
import org.logical_paradox.rss.http.Site;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.http.URLSuspender;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.lcmgr.RSSLocalContentsMgr;
import org.logical_paradox.rss.lookup.Lookup;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.robot.event.SNodeDSyncEventListener;
import org.logical_paradox.rss.router.RNodeClientFactory;
import org.logical_paradox.rss.router.RNodeDSyncMngr;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.router.SiteLock;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;
import org.logical_paradox.rss.util.RandomKeyGenerator;

/**
 * RSSWebNavigator
 * RSS Web񃍃{bgɒTׂiH肷NX
 * KvɉāCiH}X^[̃T[o[ƂƂ肵C̐iH񎦂
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.18 $
 */
public class RSSWebNavigator {
	/** K[ */
	private static final Log log = LogFactory.getLog(RSSWebNavigator.class);

	/** ftHg̐ݒt@C */
	public static final String NAVIGATIOR_CONF_FILENAME = "../conf/rssnavigator.conf";

	/** RSSWebNavigatorRtBO[V */
	private RSSNavigatorConfig cfg = null;

	/** URL */
	private URLPool urls = null;
	/** ݃g[XURL */
	private int nowFetchCnt = 0;
	/** g[X\URL̍ő */
	private int maxFetchCnt = 0;
	/** oHASY */
	private RoutingAlgorithm algo = null;
	/** bNۗLĂTCg */
	private Hashtable<String,Site> sites = null;

	/** oHm[h̃X^u */
	private RNodeClientFactory rnode = null;
	/** oHNCAg */
	private RoutingNodeClient rnClient = null;
	/** 󂯎Tm[hID */
	private String robotId = null;
	/** ɕۗLł郍bN̐ */
	private int limKeepLocks = 0;
	/** T}~ΏۂURLǗIuWFNg */
	private URLSuspender suspender = null;
	/** ŌɒTbNǗIuWFNgɑ΂GCN */
	private long siteLockLastGCTime = 0;

	/** ~tO */
	private boolean shutdownFlg = false;

	/** irQ[V[h(true:UVXe false:X^hA[) */
	private boolean navimode = true;
	/** [JRecǗVXe */
	private RSSLocalContentsMgr lcm = null;

	/** oHm[hƂ̊ԂŃbZ[ŴƂxf[ */
	private RNodeDSyncMngr dsyncman;
	/** URLGR[̏ */
	protected boolean flg_EchoURL = true;


	/**
	 * RXgN^
	 */
	protected RSSWebNavigator() {
		urls = new URLPool();
		sites = new Hashtable<String,Site>();
		suspender = new URLSuspender();
	}

	/**
	 * oHirQ[^[̃CX^XԂ
	 * @param filename oHirQ[^RtBOt@C
	 * @return oHirQ[^[
	 * @throws IllegalObjectStateException oHm[hƂ̐ڑɎs
	 * @throws RSSIllegalConfigException oHirQ[^[̐ݒt@Cs
	 * @throws IOException ݒt@C̓ǂݍ݂Ɏs
	 */
	public static RSSWebNavigator getNavigator(String filename)
					throws IllegalObjectStateException, RSSIllegalConfigException, IOException {

		RSSWebNavigator navigator = new RSSWebNavigator();

		// oHirQ[^p̃RtBO[h
		navigator.cfg = new RSSNavigatorConfig(filename != null ? filename : NAVIGATIOR_CONF_FILENAME);
		navigator.navimode = navigator.cfg.getNavigationMode();

		log.info("RSSTVXe" + (navigator.navimode==true?"UVXe":"X^hA[VXe") + "ƂĐݒ肵܂");

		navigator.maxFetchCnt = navigator.cfg.getDebugTraceURLs();
		navigator.flg_EchoURL = navigator.cfg.getEchoURL();
		navigator.limKeepLocks = navigator.cfg.getKeepLocks();
		navigator.siteLockLastGCTime = Calendar.getInstance().getTimeInMillis();

		navigator.algo = navigator.cfg.getRoutingAlgorithm();

		log.info("oHASY'" + navigator.algo.getAlgorithmName() + "'Ɏw肳܂");

		try {
			if(navigator.navimode == false) {
				// TJnURLo^鏈
				String root = navigator.cfg.getRoot();
				if(root == null || root.trim().length() == 0) {
					// 'ROOT'̍s݂Ȃꍇ
					throw new RSSIllegalConfigException();
				}

				navigator.urls.add(root);

				// X^hA[̏ꍇ͒Tm[hIDĂȂ̂ŁCŏɍ쐬
				navigator.robotId = "SNODE:" + RandomKeyGenerator.getUniqKey();
			} else {
				// oHm[hTJnʒuႤꍇ
				// ܂oHm[hփT[rXC
				// oHm[hICڑp̃NCAgX^u擾
				log.info("oHm[hɃT[rXCĂ܂");

				Lookup lookup = LookupFactory.getLookup(navigator.cfg.getDistServRegURL());
				navigator.rnode = (RNodeClientFactory)lookup.lookup(RSSDistributedServiceRegistry.RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY);
				navigator.rnClient = navigator.rnode.bindSearchNode();

				navigator.robotId = navigator.rnClient.getNodeId();

				log.info("Tm[hoHm[h[" + navigator.rnode.getNodeId() +"]ɃoCh܂");
				log.info("Tm[hID: " + navigator.robotId);

				// IPAhX͈̓Zbg𐶐
				IPAddressRangeSet rangeSet = null;

				String httpStubModeString = RSSProperties.getString(RSSConstant.RSS_PKEY_STUB_HTTP_CONNECTION);
				if(httpStubModeString != null && Boolean.valueOf(httpStubModeString).booleanValue() == true) {
					log.info("eXgڑ[ĥ߁CIP͈͂𐧌܂");
				} else {
					String[] ipranges = navigator.rnClient.getAllowedRoutingIPRanges();
					if(ipranges != null && ipranges.length > 0) {
						log.info("IPAhX͈̔͂𐧌Ă܂: " + ipranges.length + "");
						rangeSet = IPAddressRangeSetFactory.getIPAddressRangeSet();
						rangeSet.setRanges(ipranges);
					}
				}

				// f[X^[g
				navigator.dsyncman = new RNodeDSyncMngr(navigator.cfg, navigator.rnClient, 1000, navigator.urls, rangeSet);
				navigator.dsyncman.addListener(new SNodeDSyncEventListener(navigator));
				navigator.dsyncman.start();
			}
		} catch(MalformedURLException me) {
			log.info("oHm[hIT[o[URL");
			throw new IllegalObjectStateException(me.getMessage());
		} catch(RemoteException re) {
			log.info("oHm[hƂ̒ʐMɎs܂");
			throw new IllegalObjectStateException(re.getMessage());
		} catch(Exception e) {
			log.info("̑̌ɂG[ : " + e.getMessage());
			e.printStackTrace();
			throw new IllegalObjectStateException(e.getMessage());
		}

		return navigator;
	}


	/**
	 * [JRecǗVXeJnD
	 * @param filename RtBOt@C
	 * @throws RSSIllegalConfigException RtBOt@Cɕs
	 */
	public void enableLocalContentsMgr(String filename) throws RSSIllegalConfigException {
		if(lcm == null) {
			// ܂[JRecǗVXeĂȂꍇ
			// 
			lcm = new RSSLocalContentsMgr(navimode, filename);
		}
		// [JRecǗVXẽXCb`
		// ɂāCXbhJn
		lcm.start();
	}
	/**
	 * [JRecǗVXe~D
	 */
	public void disableLocalContentsMgr() {
		// [JRecǗVXe~
		if(lcm != null) {
			lcm.done();
		}
	}
	/**
	 * wURL̒TbNĂ邩ǂׂ
	 * bNĂȂꍇ́CbN擾悤Ǝ݂<br>
	 * ʂƂĂǂĂbN擾łȂꍇfalseԂ<br>
	 * ɃbNĂ邩CbN擾邱ƂoꍇtrueԂ
	 * @param url bNΏURL
	 * @return true:bN擾ł / false:łȂ
	 */
	public boolean isLocked(String url) {
		boolean rc = true;
		String siteName = getSiteNameByURL(url);
		if(siteName == null) {
			return false;
		}

		// ɏ\Ȑ̃bNۗLĂꍇCoHm[h֓]
		if(dsyncman.findLock(siteName, getRobotId()) == null && dsyncman.numOfMyLocks(getRobotId()) >= limKeepLocks) {
			try {
				dsyncman.poolURL(url);
			} catch(SyncQueueException se) {
			}
			return false;
		}

		// w肳ꂽTCgɑ΂郍bNmFC󋵂ɂĂ͎擾\Ă݂
		// ʂƂāCbNێĂȂC邢͎擾łȂꍇ͏I
		if(requireSiteLock(siteName, getRobotId()) == false) {
			log.info(url + "bNł܂ł");
			return false;
		}

		return rc;
	}

	/**
	 * w肳ꂽURLTĂǂǂ𒲂ׂ
	 * ̒ł́Crobots.txtQƂ邾<br>
	 * META^Ow肳Ă̂ɂẮCRecliKŔ肷
	 * @param url ΏURL
	 * @return true:TOK(robots.txtŋĂ) / false:T֎~
	 */
	public boolean isAllowed(String url) {
		boolean rc = false;

		String siteName = getSiteNameByURL(url);
		if(siteName == null) {
			return false;
		}

		// TCgIuWFNg̍\z
		synchronized(sites) {
			Site so = (Site)sites.get(siteName);
			if(so == null) {
				try {
					log.trace("TCgIuWFNg쐬Ă܂");
					so = Site.getInstance(url, cfg.getProperty("HTTP_USER_AGENT"));
					sites.put(siteName, so);

				} catch(IllegalArgumentException e) {
					// TCgIuWFNg𐶐邱ƂłȂ̂ŁCƂ肠
					// _ƔfĂ .. ɂ܂
					return false;
				}
			}

			if(so.hasRule() == false || so.isAllowed(url, cfg.getHttpUserAgent()) == true) {
				// robots.txt݂ȂCƂĂĂꍇ
				rc = true;
			} else {
				// robots.txt݂āC֎~Ă̈̏ꍇ
				rc = false;
			}
		}

		log.trace(url + "́C" + (rc==true?"":"֎~") + "Ă܂");
		return rc;
	}

	/**
	 * w肳ꂽTCgɑ΂郍bNmF/\
	 * bNێĂC邢͐\̌ʂƂĎ擾łꍇtrue<br>
@	 * Ƃɂ̒Tm[hł́CƂ̏oȂTCg̏ꍇfalseԂ
	 * @param dn hC
	 * @param rid Tm[hID
	 * @return true:bN̎擾ɐ / false:s
	 */
	protected boolean requireSiteLock(String dn, String rid) {
		// ܂[J̃bNǗIuWFNgmF
		if(dsyncman.findLock(dn, rid) != null) {
			return true;
		}

		// bN\Ă݂
		boolean rc = true;
		SiteLock l = new SiteLock(dn, rid);
		try {
			rc = dsyncman.lock(l);
		} catch(SyncQueueException se) {
			// bNłȂ̂ŗR\
			se.printStackTrace();
			System.out.println(se.getMessage());
			rc = false;
		}

		return rc;
	}

	/**
	 * TCgTASYݒ肷
	 * @param r TASY
	 */
	public void setRoutingAlgorithm(RoutingAlgorithm r) {
		algo = r;
	}

	/**
	 * Tm[hIDԂ
	 * @return Tm[hID
	 */
	public String getRobotId() {
		return robotId;
	}

	/**
	 * irQ[^N[Y
	 * ̏sƁCoHm[hTm[h؂藣
	 * @throws RemoteException ؒfɎs
	 */
	public void close() throws RemoteException {
		// [JRecǗVXe̒~
		// ]̃RecSăRecǗVXe֓]
		if(lcm != null) {
			log.info("[JRecǗVXe~Ă܂");
			try {
				disableLocalContentsMgr();
				log.info("[JRecǗVXe~܂");
			} catch(Exception e) {
				log.error("~ɗO܂:\n" + e.getMessage());
			}
		}

		if(navimode == RSSNavigatorConfig.NAVIMODE_STANDALONE) {
			// P̂œ삵Ăꍇ͉ȂŕԂ
			return;
		}

		log.info("oHm[hTm[h'" + getRobotId() + "'؂藣Ă܂");

		if(rnode == null) {
			throw new RemoteException("navigator has been already closed");
		}

		// ؂藣
		rnode.unbindSearchNode(getRobotId());

		log.info("'" + getRobotId() + "'́CoHm[h؂藣܂");

		rnode = null;
		rnClient = null;
	}

	/**
	 * ŤʁCꂽURLo^
	 * Kvɉă}X^[̃T[o[֓]
	 * @param contents WebRec
	 * @throws IllegalObjectStateException [JRecǗVXeŔO
	 * @throws MalformedURLException URL̃tH[}bgs
	 * @throws IOException [JRecǗVXeŔO
	 */
	public void sendContents(WebContents contents)
									throws IllegalObjectStateException, MalformedURLException, IOException {

		boolean needToStore = true;

		// 莞Ԃo߂ĂꍇCTbN̂߂GCN
		if(Calendar.getInstance().getTimeInMillis() - siteLockLastGCTime >= cfg.getSiteLockExpire()) {
			log.trace("TbÑKx[WRN^N܂");
			dsyncman.gc();
			siteLockLastGCTime = Calendar.getInstance().getTimeInMillis();
		}

		if(contents == null) {
			// WebRec܂܂ĂȂꍇ́CȂŏ߂
			return;
		}

		if(contents.isRobotsTxtFlg()) {
			// ŤʁC擾y[Wrobots.txtꍇ
			releaseSearchLock(contents);
			// ȏ͕̏KvȂ
			return;
		}

		if(StringUtils.isEmpty(contents.getDocument())) {
			// RecȂ̂ŁĈ܂ܕԂ
			return;
		}

		// AJ[^O̎W
		Vector<String> anchors = null;
		try {
			anchors = HREFCollector.collect(contents.getOriginalDocument());
		} catch(NoIndexException noe) {
			// Yy[Windexing֎~Ăꍇ
			if(noe.isFollowable() == true) {
				anchors = noe.getAnchorsInThisPage();		// null̏ꍇ̂Œ

				// webRec𖳌鏈
				needToStore = false;
			}
		}
		Vector<String> an = HREFCollector.getAnchorsAsABSPath(contents.getURL(), anchors);
		if(an == null) {
			return;
		}

		int receives = maxFetchCnt == 0 || (an.size() + nowFetchCnt) < maxFetchCnt ? an.size() : maxFetchCnt - nowFetchCnt;

		int nowURLs = urls.size();

		try {
			for(int i = 0; i < receives; i++) {
				if(dsyncman != null && nowURLs >= cfg.getKeepUrls() && navimode == RSSNavigatorConfig.NAVIMODE_DISTRIB) {
					// ȏURLۊǂłȂꍇ͌oHm[h֓]邽߂Ƀv[
					// CUVXeƂē삵Ăꍇ̂݁D]͓f[ɂ
					dsyncman.poolURL((String)an.elementAt(i));
				} else {
					// ]͂̂ŁCTm[hŏ
					urls.add((String)an.elementAt(i));
					nowURLs++;
				}
			}
		} catch(SyncQueueException se) {
		}

		nowFetchCnt += receives;

		// RecǗVXeɑ΂āCRec𑗏o
		// RecindexingĂ̂ɂĂ̂
		if(lcm != null && needToStore == true) {
			synchronized(lcm) {
				while(lcm.isReceivable() == false) {
					try {
						lcm.wait();
					} catch(InterruptedException e) {}
				}
			}

			lcm.store(contents);
		}
	}


	/**
	 * T}Ԃ畜A
	 * robots.txt擾łꍇCTCgIuWFNgɑ΂ă[ݒ肷
	 * @param contents WebRec
	 * @throws IllegalObjectStateException TCgbN̐
	 */
	public void releaseSearchLock(WebContents contents) throws IllegalObjectStateException {
		// f[^ɂSiteIuWFNgXV(y[W擾[ݒ肷)
		String dn = getSiteNameByURL(contents.getLocation());
		if(dn == null) {
			return;
		}

		Site s = (Site)sites.get(dn);
		if(s == null) {
			// OɃTCgIuWFNgĂȂ̂ŁC
			// eXg[h̏ꍇɂ悭̂ŁCƂ肠ƂĂ͌p
			log.warn("TCgIuWFNgȂ̂Ŗ܂");
			return;
		}
		if(StringUtils.isEmpty(contents.getDocument())) {
			// Rec܂łȂꍇ(404̏ꍇ)͉Ȃ
			log.trace("URL: " + contents.getLocation() + "݂͑܂ł");
		} else {
			// robots.txtŁC炩̃f[^܂łꍇ͓WJ
			ByteArrayInputStream in = new ByteArrayInputStream(contents.getDocument().getBytes());
			try {
				s.getRuleFromTheSite(in);
				log.trace("TCg'" + dn + "'̃[ݒ肵܂");
			} catch(IOException ie) {
				log.error("robots.txt̉͂Ɏs");
			}
		}

		// robots.txtۂɂǂɊւ炸CŒT}Ԃ畜A
		try {
			sites.put(dn, s);
			String[] releasedURLs = suspender.release(dn);
			if(releasedURLs != null) {
				// ꂽURL݂̂ŁCSL[ɖ߂
				pushbackURLs(releasedURLs);
			}
			log.trace("TCg'" + dn + "'̒T}Ԃ܂");
		} catch(IllegalArgumentException ie) {
			log.trace("TCg'" + dn + "'̉Ɏs܂", ie);
		}
	}

	/**
	 * ɒTׂURL擾
	 * oURL͎IɃXg폜
	 * @return ɒTׂURL
	 */
	public String getNextURL() {
		String rc = null;

		while((rc = algo.nextURL(urls)) != null) {
			// oꂽURLC擾Ă邩ǂ𒲂ׂ
			// ĂȂꍇCURL͎̂Ă
			try {
				if(suspender.isSuspended(rc) == true) {
					// T}ĂURLȂ̂ŁCT}IuWFNgɓo^(L[͍폜邪CT}ꂽiKōē)
					String dn = getSiteNameByURL(rc);
					if(dn != null) {
						suspender.suspend(Site.getInstance(dn, cfg.getHttpUserAgent()), rc);
					}
				}
			} catch(IllegalArgumentException e) {
				// URL̂Ŏ̂Ă
				// ȂƎ̂ĂƂɂȂ
				continue;
			}

			// oꂽURLɑΉSiteIuWFNg݂邩ǂ𒲂ׂ
			String dn = getSiteNameByURL(rc);
			if(dn == null) {
				// URL̂Ŏ̂Ă
				continue;
			}

			// bN̎擾
			if(isLocked(rc) == true) {

				// bN擾łC邢͍ŏ珊Ăꍇ
				if(sites.get(dn) == null) {

					// TCgIuWFNg݂Ȃꍇrobots.txtURLƂĕԂ
					Site s = Site.getInstance(rc, cfg.getHttpUserAgent());

					// ɁCTCgIuWFNgT}ǗIuWFNgɓo^
					suspender.suspend(s, rc);

					// TCrobots.txtQƂN_ɂȂURL폜
					// URLƂōēxT邽߂ɕKvɂȂ
					algo.removeFromHistory(rc);

					// Vrobots.txtURL쐬ĕԂ
					rc = s.getRobotsTxtURL();

					// ƁCTCgIuWFNgo^
					sites.put(dn, s);
					break;
				} else if(isAllowed(rc) == true) {
					// TCgIuWFNg݂ꍇŁCTĂꍇ
					// Ōł悢̂ŁC[vEo
					break;
				}
			} else {
				// bN擾łȂ̂ŁCURL͂ȂƂɂ
				// ȂƎ̂ĂƂɂȂ
				// Kvł΁Cɕʂ̒Tm[hւ̓]Ăǂ
			}
		}

		return rc;
	}

	/**
	 * URLvbVobN
	 * @param u vbVobNURL̔z
	 */
	private void pushbackURLs(String[] u) {
		if(u == null) {
			return;
		}

		for(int i = 0; i < u.length; i++) {
			try {
				urls.add(u[i]);
			} catch(MalformedURLException ue) {
				// ǉ悤ƂURLɉ肪ꍇ͖
			}
		}
	}

	/**
	 * URL̎cʂԂ
	 * @return URL̎c
	 */
	public int getQueueSize() {
		return urls.size();
	}

	/**
	 * URL0̊Ԃ̓Xbh~
	 */
	public void waitUntilEmpty() {
		urls.waitUntilEmpty();
	}

	/**
	 * ̌oHirQ[^ɋ@\~Ă邩ǂԂ
	 * w肳ꂽURLi[CSă{bgTꍇ͒~ԂɂȂ
	 * @return true:oHirQ[^͒~\ / false:s
	 */
	public boolean isFinished() {
		if(shutdownFlg == true) {
			return true;
		}
		if(countSuspendedSites() + urls.size() == 0 && maxFetchCnt > 0 && nowFetchCnt >= maxFetchCnt) {
			// T}URLƃL[ۂŁCi[lݒ肳ĂāC̐ꍇ
			return true;
		} else {
			// ȊO
			return false;
		}
	}

	/**
	 * T}Ԃ̃TCg邩ǂ𒲂ׂ
	 * @return T}Ԃ̃TCg
	 */
	public int countSuspendedSites() {
		return suspender.size();
	}

	/**
	 * SURLTCg𒊏o
	 * @param url URL
	 * @return hC
	 */
	private String getSiteNameByURL(String url) {
		// SURLChC̕؂o
		try {
			URL u = new URL(url);
			return u.getHost() + (u.getPort() > 0 ? ":" + u.getPort() : "");
		} catch(MalformedURLException e) {
			return null;
		}
	}

	/**
	 * irQ[V[hԂ
	 * @return true:UVXe / false:standalone
	 */
	public boolean getNavigationMode() {
		return navimode;
	}
	/**
	 * oHirQ[^[IɃVbg_E
	 */
	public void shutdown() {
		shutdownFlg = true;
	}
}

// end of RSSWebNavigator.java
