package org.logical_paradox.rss.rcm.accessor.simple;

import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeResultSet;
import org.logical_paradox.common.btree.BtreeSession;
import org.logical_paradox.common.charset.CharsetUtils;
import org.logical_paradox.common.vrm.RecordFactory;
import org.logical_paradox.common.vrm.VariableRecordManager;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;


/**
 * t@Cx[X̃RecǗsȂCłPȃRecANZT<br>
 * inodȇ݂̑ɂāCSlĂȂCJƃeXĝ߂̂<br>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.15 $
 */
public class SimpleFileContentsAccessor implements ContentsAccessor {
	/** DSR */
	private String dsruri;
	private String contentsEncoding;
	private boolean needToEncode = false;
	private static Btree btree = null;					// VMňӂb-treeǗNX
	private static int clientCounter = 0;				// b-treeZbṼJE^
	private BtreeSession session = null;					// b-treeZbV
	private static DataFilter dataFilter;					// Recf[^tB^
	private static VariableRecordManager manager = null;	// Reci[ϒR[h}l[W[

	/** ̃RecANZTLRecT[rX̊SCT[rX */
	private String fqsn;

	private static VirtualQueueServer queue;				// zL[T[o[

	static {
		dataFilter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);
	}

	/**
	 * RecANZTD
	 * @param initparam p[^
	 */
	public void init(String initparam) {
		fqsn = initparam;
		open(initparam);
	}

	/**
	 * RecǗXg[Wւ̐ڑI[v
	 * t@CǗȂ̂ŁCʂɐڑ̕Kv͂Ȃ
 	 */
	public void open(String openstr) {
		try {
			if(btree == null) {
				// VMŏ̏ꍇBtreeNX̃C^X1
				btree = Btree.getInstance(new RCMBtreeFactory());
				btree.open(openstr + ".idx");

				// zL[T[o[֐ڑ
				queue = new VirtualQueueServer(dsruri);
			}
			// b-treep̃ZbVI[v
			session = btree.getSession();
			clientCounter++;

			if(manager == null) {
				// VMŏ̏ꍇVRM̃CX^X1쐬
				manager = new VariableRecordManager(openstr + ".dat", RecordFactory.getInstance("org.logical_paradox.rss.rcm.accessor.simple.ContentsRecordFactory"));
			}
		} catch(Exception e) {
			e.printStackTrace();
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * Reco^
	 * @param contents o^Rec
	 */
	public void regist(WebContents contents) {
		try {
			String url = contents.getLocation();
			String document = contents.getDocument();

			// wURLMD5_CWFXg擾āCRecƊ֘AtL[Ƃ
			String digest = dataFilter.filterURL(url);
			RCMBtreeKey key = (RCMBtreeKey)session.newKey(digest);

			// wL[ɊYf[^ɓo^Ă邩ǂ𒲂ׂ
			// _CWFXgdȂꍇȂƂȂ̂
			BtreeResultSet result = session.find(key);
			ContentsRecord cr = new ContentsRecord();
			if(result != null) {
				key = (RCMBtreeKey)result.getKey();
				// Ƀf[^̂ŁC̃f[^擾
				cr = (ContentsRecord)manager.get(key.getOffset());
			}
			// Reco^
			cr.add(new ContentsByteStream(dataFilter.compressContents(document.getBytes())));
			long rno = manager.insert(cr);

			// R[h̃oCgψʂݒCL[XV
			key.setOffset(rno);
			session.insert(key);

			// L[URL𓊓
			queue.enqueue(digest + "::" + fqsn);
		} catch(Exception e) {
			e.printStackTrace();
			throw new IllegalStateException(e.getMessage());
		}
	}

	/**
	 * Rec폜
	 */
	public void unregist( String url ) {
		throw new IllegalStateException( "̃\bh͎Ă܂" );
	}

	/**
	 * SẴRec폜
	 */
	public void unregistAll() {
		throw new IllegalStateException( "̃\bh͎Ă܂" );
	}

	/**
	 * RecT
	 * 
	 * @param url URL
	 * @return 擾łRec
	 */
	public String find(String url) {
		try {
			RCMBtreeKey key = (RCMBtreeKey)session.newKey(dataFilter.filterURL(url));
			BtreeResultSet result = session.find(key);
			if(result == null || result.getKey() == null) {
				return null;
			}

			// ReĉŁCL[ɋL^Ă郌R[hVRMŃ[h
			key = (RCMBtreeKey)result.getKey();
			ContentsRecord cr = (ContentsRecord)manager.get(key.getOffset());
			if(cr == null) {
				throw new IllegalStateException("no such record:" + key.getOffset() + " binded as " + key.toString());
			}
			ContentsByteStream cbs = cr.toArray()[0];

			// oCg(gzipňkĂ)Rec𕜌ĕԂ
			return new String(dataFilter.decompressContents(cbs.byteStream()));

		} catch(Exception e) {
			e.printStackTrace();
			throw new IllegalStateException(e.getMessage());
		}
	}

	/**
	 * Xg[WƂ̐ڑ
	 */
	public void close() {
		clientCounter--;

		if(clientCounter == 0) {
			// I[vĂZbVȂ̂b-treeVRM
			try {
				session.close();
				manager.close();
			} catch (Exception e) {
				e.printStackTrace();
				throw new IllegalStateException(e.getMessage());
			}
		}
		session = null;
		manager = null;
	}

	/**
	 * ڑDSRݒ肷D
	 * @param uri DSR uri
	 */
	public void setDSRURI(String uri) {
		dsruri = uri;
	}
	/**
	 * RecǗۂ̃GR[fBOݒ肷D
	 * @param encoding GR[fBO
	 */
	public void setContentsEncoding(String encoding) {
		contentsEncoding = encoding;
		try {
			needToEncode = CharsetUtils.testNeedToEncode(encoding);
		} catch(Exception e) {
			needToEncode = false;
		}
	}
}

// end of SimpleFileContentsAccessor.java
