/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ContentsAccessorFactory.java,v 1.8 2006/02/21 14:54:47 akabane Exp $
 */
package org.logical_paradox.rss.rcm.accessor;

import java.util.HashMap;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.common.util.StringUtils;

/**
 * ContentsAccessorFactory
 * RecXg[WփANZX邽߂̃ANZT𐶐鐶q̊C^[tF[X
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class ContentsAccessorFactory {
	/** RecANZXC^[tF[X̋ۃNX */
	public static final String PARAM_ACCESSOR_CLASSNAME = "param.accessor.classname";
	/** ڑDSRURI */
	public static final String PARAM_DSR_URI = "param.dsr.uri";
	/** RecANZXC^[tF[X̏p[^ */
	public static final String PARAM_INIT_PARAM = "param.init.param";
	/** Reci[ۂ̃GR[fBO */
	public static final String PARAM_CONTENTS_ENCODING = "param.contents.encoding";

	/** K[ */
	private static final Log log = LogFactory.getLog(ContentsAccessorFactory.class);
	/** RecANZT̃NXt@C */
	private Class seed;
	/** p[^ */
	private String initparam;
	/** ɐꂽC^[tF[X */
	private HashMap<String, ContentsAccessor> instances = new HashMap<String, ContentsAccessor>();
	/** DSR */
	private String dsruri;
	/** RecǗۂ̃GR[fBO */
	private String contentsEncoding;

	/**
	 * RXgN^D
	 * @param factoryInitProperties t@Ngp[^
	 * @throws ClassNotFoundException ANZTłȂ
	 */
	public ContentsAccessorFactory(Properties factoryInitProperties) throws ClassNotFoundException {
		// t@Ng
		String classname = factoryInitProperties.getProperty(PARAM_ACCESSOR_CLASSNAME);

		seed = Class.forName(classname);
		initparam = factoryInitProperties.getProperty(PARAM_INIT_PARAM);
		dsruri = factoryInitProperties.getProperty(PARAM_DSR_URI);
		contentsEncoding = factoryInitProperties.getProperty(PARAM_CONTENTS_ENCODING);
	}
	/**
	 * VRecANZT𐶐ĕԂD
	 * p[^ŐꂽCX^X͋L
	 * @return ꂽRecANZT
	 * @throws IllegalArgumentException Ɏs
	 */
	public ContentsAccessor getAccessor() throws IllegalArgumentException {
		try {
			String initp = initparam != null ? initparam : "";
			ContentsAccessor accessor = (ContentsAccessor)instances.get(initp);
			if(accessor != null) {
				return accessor;
			}
			accessor = (ContentsAccessor)seed.newInstance();
			accessor.setDSRURI(dsruri);
			accessor.setContentsEncoding(contentsEncoding);
			if(StringUtils.isEmpty(initp) == false) {
				// p[^w肳ĂꍇCinit()Ăяo
				accessor.init(initparam);
			}
			instances.put(initp, accessor);

			return accessor;
		} catch(Exception e) {
			String stackTraceMsg = ExceptionUtils.stackTraceToString(e);
			log.error("RecANZTɃG[܂:[" + e.getMessage() + "]", e);
			log.error(stackTraceMsg);
			throw new IllegalArgumentException(e.getMessage());
		}
	}
}

// end of ContentsAccessorFactory.java
