/*
 * $Id: HashMapLookup.java,v 1.4 2006/01/28 03:37:07 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.lookup.impl;

import static org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry.RSS_SERVID_SERVICE_LOCATER;

import java.rmi.RemoteException;
import java.util.HashMap;

import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.Lookup;

/**
 * nbV}bvgp^CṽbNAbv
 * eXgȂǂŎgp邽
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class HashMapLookup implements Lookup {
	/** oCh^[Qbg */
	private String bindTarget;

	/** T[rXWXg(JVM1) - rmiregistry̑ƂĎgp邽 */
	private static final HashMap<String, Service> registry = new HashMap<String, Service>();

	/** Ulbg[ÑGh|CgDSR */
	private RSSDistributedServiceRegistry dsr = null;

	/**
	 * RXgN^
	 * @param bt oCh^[Qbg(̎̏ꍇdsruri)
	 */
	public HashMapLookup(String bt) {
		dsr = (RSSDistributedServiceRegistry)registry.get(bt);
		bindTarget = bt;
	}

	/**
	 * UT[rXoCh܂D
	 * oCh́CL敪U\[Xlbg[N肵܂D
	 * @return ۂɃoChꂽۂ̎ʕ
	 * @throws Exception oChɎs
	 */
	public String bind(int type, Object o) throws Exception {
		Service r = (Service)o;

		// UT[rXWXgɑ΂āCVT[rXo^
		String node = dsr.bind(type, r);
		// [JWXgɃT[o[o^
		registry.put(node, r);

		return node;
	}
	/**
	 * UT[rXAoCh܂D
	 * @param type T[rX̃^Cv
	 * @param name o^m[h
	 * @throws Exception AoChɎs
	 */
	public void unbind(int type, String name) throws Exception {
		dsr.unbind(type, name);
		registry.remove(name);
	}

	/**
	 * DSRWXgɓo^
	 * @param stub DSR̃CX^X
	 * @throws Exception o^Ɏs
	 */
	public void register(RSSDistributedServiceRegistry stub) throws Exception {
		registry.put(stub.getName(), stub);
		dsr = stub;
	}

	/**
	 * L敪U\[Xlbg[NC̎ނ̃T[rX𔭌܂D
	 * @param name T[rX̎
	 * @return ꂽT[rX̃X^u
	 * @throws Exception Ɏs
	 */
	public Object lookup(int type) throws Exception {
		// DSRɖ₢킹
		return dsr.getService(type);
	}

	/**
	 * wm[hID̃T[rXԂ܂D
	 * @param nodeId m[hID
	 * @return T[rX̃X^v
	 * @throws Exception bNAbvɎs
	 */
	public Service lookup(String nodeId) throws Exception {
		if(dsr.getName().equals(nodeId)) {
			return dsr;
		} else {
			return dsr.getService(nodeId);
		}
	}

	/**
	 * ̔T[rX̃oCh^[Qbg(ڑm[h)Ԃ
	 * @return oCh^[Qbg
	 */
	public String[] services(int type) throws Exception {
		return dsr.services(type);
	}

	/**
	 * ̔T[rX̃oCh^[Qbg(ڑm[h)Ԃ
	 * @return oCh^[Qbg
	 */
	public String getBindTargetName() {
		return bindTarget;
	}

	/**
	 * ̔T[rX̃oCh^[Qbgɑ΂āA[eBOe[u̍XVw
	 * @throws Exception XVɔO
	 */
	public void configure() throws Exception {
		dsr.configure();
	}

	/**
	 * [gQƂ݂ɋL
	 * @param stub o^Ă炤X^u
	 * @throws RemoteException o^Ɏs
	 */
	public Service hug(Service stub) throws Exception {
		dsr.bind(RSS_SERVID_SERVICE_LOCATER, stub);
		return dsr;
	}

	/**
	 * [gQƂ݂ɋL
	 * o^𖾎IɎwł
	 * @param stub o^Ă炤X^u
	 * @param name T[rX
	 * @return RemoteException o^Ɏs
	 */
	public Service hug(String name, Service stub) throws Exception {
		dsr.bind(RSS_SERVID_SERVICE_LOCATER, name, stub);
		return dsr;
	}

}
