/**
 * EncodingContentsFilter
 * GR[fBOIɐ̂ɕϊtB^
 */
package org.logical_paradox.rss.http.contents;

import java.io.UnsupportedEncodingException;


public class EncodingContentsFilter extends ContentsFilter {
	String baseEncoding = null;

	public EncodingContentsFilter() {
	}
	public EncodingContentsFilter( String encoding ) {
		if( encoding != null ) {
			baseEncoding = encoding;
		}
	}

	public String filter( String src ) {
		if( baseEncoding == null ) {
			return src;
		}

		try {
			// ϊ
			String dest = new String( src.getBytes( System.getProperty( "file.encoding" ) ), baseEncoding );
			return dest;
		} catch( UnsupportedEncodingException ue ) {
			// ϊłȂꍇ́Ĉ܂ܕԂ
			return src;
		}
	}
}

// end of EncodingContentsFilter.java
