/*
 * $Id: URLPool.java,v 1.6 2006/02/19 04:58:13 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.http;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;


/**
 * URLPool
 * TURLi[ĂIuWFNg
 * @author satoshi akabane
 * @version $Revision: 1.6 $
 */
public class URLPool {
	/** hCǗe[u */
	private Hashtable<String, HashSet<String>> domain = null;

	/**
	 * RXgN^D
	 */
	public URLPool() {
		domain = new Hashtable<String, HashSet<String>>();
	}

	/**
	 * URLǉD
	 * @param url ǉURL
	 * @throws MalformedURLException URLsł
	 */
	public void add(String url) throws MalformedURLException {
		synchronized(domain) {
			// URLhC̕𒊏o
			String dn = getDomainName(url);
			if(dn == null || dn.trim().length() == 0) {
				throw new MalformedURLException();
			}

			// URL𐳋K
			url = normalize(url);

			// YhCURLZbg擾
			HashSet<String> s = domain.get(dn);
			if(s == null) {
				s = new HashSet<String>();
				domain.put(dn, s);
			}
	
			// URLǉ
			// HashSetȂ̂ŏd͏㏑D]Ĕ͕KvȂ
			s.add(url);

			domain.notifyAll();
		}
	}

	/**
	 * URL𐳋KD
	 * ̓Iɂ́C'#'ȍ~JbgD
	 * @param url URL
	 * @return KꂽURL
	 */
	public String normalize(String url) {
		int pos = url.indexOf('#');
		return pos < 0 ? url : url.substring(0, pos);
	}
	/**
	 * URL܂Ƃ߂ĒǉD
	 * @param urls o^URL̔z
	 * @throws MalformedURLException URLsł
	 */
	public void add(String[] urls) throws MalformedURLException {
		synchronized(domain) {
			for(String url : urls) {
				if(urls != null) {
					add(url);
				}
			}
	
			domain.notifyAll();
		}
	}

	/**
	 * URL܂Ƃ߂ĒǉD
	 * @param i Ce[^
	 * @throws MalformedURLException URLsł
	 */
	public void add(Iterator<String> i) throws MalformedURLException {
		synchronized(domain) {
			while(i.hasNext()) {
				add(i.next());
			}
			domain.notifyAll();
		}
	}

	/**
	 * w͈͂̃hCԂD
	 * @param idx CfbNX
	 * @param len 
	 * @return hC
	 */
	public String[] domains(int idx, int len) {
		String[] d = domains();
		Vector<String> p = new Vector<String>();

		// w͈͂̃hCtFb`
		for(int i = 0; i < len && i < d.length; i++) {
			p.addElement(d[i]);
		}

		// ̔zɂĕԂ
		return (String[])p.toArray(new String[0]);
	}

	/**
	 * hCꗗԂD
	 * @return hCꗗ
	 */
	public String[] domains() {
		Set<String> keys = null;
		synchronized(domain) {
			keys = domain.keySet();
		}

		if(keys == null) {
			return null;
		}
		return (String[])keys.toArray(new String[0]);
	}

	/**
	 * whCURLԂD
	 * whCURL݂ȂꍇnullԂ
	 * @param dn hC
	 * @return URLꗗ
	 */
	public String[] urls(String dn) {
		HashSet<String> set = domain.get(dn);
		if(set == null) {
			return null;
		}

		return (String[])set.toArray(new String[0]);
	}

	/**
	 * whC̃Ce[^ԂD
	 * whCURL݂ȂꍇnullԂ]
	 * @param dn hC
	 * @return  Ce[^
	 */
	public Iterator<String> getURLIterator(String dn) {
		HashSet<String> set = domain.get(dn);
		if(set == null) {
			return null;
		}

		return set.iterator();
	}

	/**
	 * URLhC̕擾D
	 * ̏ꍇC|[gԍvgR͊֌WȂ̂Ƃ<br>
	 * TuhC͊֌ŴƂ(ʂ̃T[o[ł\邽)<br>
	 * @param url URL
	 * @return hC
	 * @throws MalformedURLException URLsł
	 */
	protected String getDomainName(String url) throws MalformedURLException {
		URL u = new URL(url);
		String siteName = u.getHost();

		return siteName;
	}

	/**
	 * wURLv[폜D
	 * @param url 폜ΏURL
	 * @throws MalformedURLException URLsł
	 */
	public void remove(String url) throws MalformedURLException {
		synchronized(domain) {
			String dn = getDomainName(url);
			if(dn == null || dn.trim().length() == 0) {
				throw new MalformedURLException();
			}

			HashSet set = domain.get(dn);
			if(set == null) {
				return;
			}

			// 폜
			set.remove(url);

			if(set.size() == 0) {
				// URL1ۗLȂhCɂȂĂ܂ꍇ
				// ̃hC폜
				domain.remove(dn);
			}
			domain.notifyAll();
		}
	}

	/**
	 * whC폜D
	 * @param domainname 폜ΏۃhC
	 */
	public void removeDomain(String domainname) {
		synchronized(domain) {
			HashSet domainSet = domain.remove(domainname);
			if(domainSet != null) {
				domainSet.clear();
			}

			domain.notifyAll();
		}
	}

	/**
	 * ̃v[̃TCYԂD
	 * @return TCY
	 */
	public int size() {
		int remain = 0;

		synchronized(domain) {
			Enumeration e = domain.elements();
			while(e.hasMoreElements()) {
				HashSet s = (HashSet)e.nextElement();
				remain += s.size();
			}

			domain.notifyAll();
		}

		return remain;
	}

	/**
	 * ̃v[Ƀf[^i[Ă邩ǂԂ
	 * @param true: i[Ă / false: i[ĂȂ
	 */
	public boolean isEmpty() {
		boolean rc = false;
		synchronized(domain) {
			rc = domain.isEmpty();
		}

		return rc;
	}

	/**
	 * ̃IuWFNg̊ԁCXbh̑҂킹D
	 */
	public void waitUntilEmpty() {
		synchronized(domain) {
			while(domain.isEmpty() == true) {
				try {
					domain.wait();
				} catch(InterruptedException ie) {
					// ҂킹IɏIDʂɂȂ炻Ō\
				}
			}
		}
	}
}
