/*
 * $Id: SyncQueue.java,v 1.6 2006/01/28 03:37:07 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsync;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/**
 * SyncQueue
 * pbP[W
 * ̂߂̏񂪊i[CǗIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class SyncQueue {
	/** pbP[W̗e(vf) */
	public static final int SYNCQUEUE_SIZE = 65536;
	/** L[̃TCY */
	private int packageSize;
	/** L[ */
	private Hashtable<String, Hashtable<String, SyncCommand>> buf = new Hashtable<String, Hashtable<String, SyncCommand>>();

	/**
	 * RXgN^
	 */
	public SyncQueue() {
		packageSize = SYNCQUEUE_SIZE;
	}
	/**
	 * RXgN^
	 * @param p L[̃TCY
	 */
	public SyncQueue(int p) {
		packageSize = p;
	}

	/**
	 * R}hǉ
	 * @param p R}h
	 * @throws SyncQueueException L[ւ̊i[Ɏs
	 */
	public void add(SyncCommand o) throws SyncQueueException {
		if(buf.size() >= packageSize) {
			throw new SyncQueueException();
		}

		// R}hi[鏈
		// ₷悤ɁCʂɐĊi[Ă
		Hashtable<String, SyncCommand> oSet = (Hashtable<String, SyncCommand>)buf.get((String)o.getTo());
		if(oSet == null) {
			oSet = new Hashtable<String, SyncCommand>();
		}

		oSet.put(o.getObject().toString(), o);
		buf.put(o.getTo(), oSet);
	}
	/**
	 * SĂ̗vfo
	 * @param o^ĂSĂ̓R}h
	 */
	public SyncCommand[] getAll() {
		ArrayList<SyncCommand> commands = new ArrayList<SyncCommand>();

		synchronized(buf) {
			for(Hashtable<String, SyncCommand> commandsToAnNode : buf.values()) {
				commands.addAll(commandsToAnNode.values());
			}
		}

		return commands.toArray(new SyncCommand[0]);
	}
	/**
	 * ɈĂR}ho
	 * of[^͍폜
	 * @param myname om[hID
	 * @return w肵m[hĂ̓R}h̃Xg
	 */
	public SyncCommand[] get(String myname) {
		Hashtable<String, SyncCommand> oSet = buf.remove(myname);
		if(oSet == null) {
			// ĂɉZbgĂȂ
			return new SyncCommand[0];
		}

		Vector<SyncCommand> dic = new Vector<SyncCommand>(oSet.values());
		return dic.toArray(new SyncCommand[0]);
	}
	/**
	 * Xgɒǉ
	 * ǉ̍ہCd̂Sč폜<br>
	 * x̎dg݂ł́Cem[h͒̃m[hȊOǗȂD<br>
	 * ʏ킠m[hɐڑ鉺ʃm[h́C100𒴂邱ƂȂ(}Vp[̊֌WŖۂ)<br>
	 * ܂Chashɂ錟͂ȂȂł邱ƂC̃ASYŖȂƎvD<br>
	 * <br>
	 * \z郊XN<br>
	 * Eʃm[h̐ɒ[ɑȂꍇ<br>
	 * Exɓ]鍷̐CɑȂꍇ<br>
	 * EsynchronizedubN<br>
	 * @param o o^铯R}h
	 * @return 󂯕tۂꂽR}h̃Xg
	 */
	public SyncCommand[] add(SyncCommand[] o) {
		ArrayList<SyncCommand> rejectedCommands = new ArrayList<SyncCommand>();

		for(int ci = 0; ci < o.length; ci++) {
			synchronized(buf) {
				Iterator i = buf.values().iterator();
				boolean commandDuplicated = false;

				SyncCommand command = null;
				Hashtable commands = null;

				while(i.hasNext()) {
					commands = (Hashtable)i.next();
					command = (SyncCommand)commands.get(o[ci].getObject().toString());
					if(command != null) {
						// 
						commandDuplicated = true;
						break;
					}
				}

				if(commandDuplicated) {
					switch(o[ci].getType()) {
						case SyncCommand.COMMAND_LOCK:
						case SyncCommand.COMMAND_FORWARD_URL:
							// ΏۂƂȂR}hɑ݂ꍇ́C폜߂ɕϊ
							o[ci].reverse();
							String from = o[ci].getFrom();
							o[ci].setTo(from);					// Ƃ֖߂
							rejectedCommands.add(o[ci]);
							break;

						case SyncCommand.COMMAND_UNLOCK:
						case SyncCommand.COMMAND_UNFORWARD_URL:
							// ΏۂƂȂR}hɑ݂ĂꍇC
							// 폜ĐV̂ǉ
							commands.remove(o[ci].getObject().toString());
							break;
						default:
					}
				} else {
					// ΏۂƂȂR}h܂݂ĂȂꍇCR[h쐬
					Hashtable<String, SyncCommand> h = (Hashtable<String, SyncCommand>)buf.get(o[ci].getTo());
					if(h == null) {
						h = new Hashtable<String, SyncCommand>();
					}
					h.put(o[ci].getObject().toString(), o[ci]);
					buf.put(o[ci].getTo(), h);
				}
			}
		}

		return (SyncCommand[])rejectedCommands.toArray(new SyncCommand[0]);
	}

	/**
	 * w肳ꂽR}h폜
	 * @param command 폜Ώۂ̓R}h
	 */
	public void remove(SyncCommand command) {
		synchronized(buf) {
			Hashtable<String, SyncCommand> oSet = buf.remove(command.getTo());
			if(oSet != null) {
				// ꍇ̓Xg폜Ċi[Ȃ
				oSet.remove(command.getObject().toString());
				buf.put(command.getTo(), oSet);
			}
		}
	}
	/**
	 * wm[hɑ΂R}hSč폜
	 * @param nk m[hID
	 */
	public void clear(String nk) {
		synchronized(buf) {
			Hashtable commandsOfTheNode = (Hashtable)buf.get(nk);
			if(commandsOfTheNode != null) {
				commandsOfTheNode.clear();
				buf.remove(commandsOfTheNode);
			}
		}
	}
	/**
	 * S폜
	 */
	public void clear() {
		synchronized(buf) {
			Iterator i = buf.values().iterator();
			while(i.hasNext()) {
				Hashtable h = (Hashtable)i.next();
				h.clear();
			}

			buf.clear();
		}
	}
}

// end of SyncQueue.java
