/*
 * $Id: RSSSyncDaemon.java,v 1.7 2006/01/27 16:39:04 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsync;

import java.util.TooManyListenersException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsync.event.DelayedSyncEvent;
import org.logical_paradox.rss.dsync.event.DelayedSyncEventListener;

/**
 * RSSSyncDaemon
 * RSŜm[hœ삷Cxf[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class RSSSyncDaemon extends Thread {
	/** K[ */
	private static final Log log = LogFactory.getLog(RSSSyncDaemon.class);
	/** G[̋e */
	public static final int SYNCD_ERROR_LIMIT = 5;
	/** C^[tF[X */
	private RSSSyncInterface syncIF;
	/** ݒt@C */
	private RSSSyncConfig syncdConfig;
	/** L[ */
	private SyncQueue syncq = null;
	/** G[A */
	protected int errorCount = 0;
	/** Xbhғł邩ǂ(true:ғ / false:~) */
	private boolean loop = true;
	/** ̒xf[zuĂm[hID */
	private String nodeId;
	/** CxgXi[ */
	private DelayedSyncEventListener eventListener;
	/** em[hID */
	private String parentNodeId;

	/**
	 * RXgN^
	 * @param conf RtBO
	 * @param si C^[tF[X
	 * @throws Exception CX^XɎs
	 */
	public RSSSyncDaemon(RSSSyncConfig conf, RSSSyncInterface si) throws Exception {
		syncIF = si;
		syncdConfig = conf;

		parentNodeId = si.getParentNodeId();

		syncq = new SyncQueue(syncdConfig.getSyncQueueSize());

		nodeId = si.getNodeId();
		// f[XbhƂē
		setDaemon(true);
	}
	/**
	 * CxgXi[ǉ(Xi[1ǉ邱ƂłȂ)
	 * @param listener CxgXi[
	 * @throws TooManyListenersException ɃCxgXi[o^Ă
	 */
	public void addListener(DelayedSyncEventListener listener) throws TooManyListenersException {
		if(eventListener != null) {
			throw new TooManyListenersException("Xi[͒ǉłȂ̂ŁCx폜Kv܂");
		}
		eventListener = listener;
	}
	/**
	 * CxgXi[폜
	 */
	public void removeListener() {
		if(eventListener != null) {
			eventListener = null;
		}
	}
	/**
	 * Xbh̃C\bh
	 */
	@Override
	public void run() {
		write("xf[Jn܂");
		try {
			while(loop) {
				sleep(syncdConfig.getSyncInterval());

				// ̓]ƎM
				SyncCommand[] receivedElements = sync();
				if(receivedElements != null) {
					errorCount = 0;
					// MR}h̃nhĂяo
					handleAllEvents(receivedElements);
				} else if(errorCount >= SYNCD_ERROR_LIMIT) {
					loop = false;
				}
			}
			write("G[w񐔘AĔ߁Cf[~܂");
			done();
		} catch(InterruptedException intrexp) {
			write("f[ɑ΂~߂M܂");
			done();
		}
	}
	/**
	 * Oo
	 * @param ls M镶
	 */
	protected void write(String ls) {
		log.trace(ls);
	}
	/**
	 * O瓯f[~
	 */
	public void shutdown() {
		loop = false;
	}
	/**
	 * f[~
	 */
	protected void done() {
		write("f[~܂");
	}
	/**
	 * f[ɑ΂ăR}hGg[
	 * @param command R}h
	 * @throws SyncQueueException R}h̏Ɏs
	 */
	public void add(SyncCommand command) throws SyncQueueException {
		try {
			if(command.getTo() == null) {
				// 悪w肳ĂȂꍇCC^[tF[Xڑ̃m[hID擾ăZbg
				command.setTo(parentNodeId);
			}
			if(command.getFrom() == null) {
				// Mw肳ĂȂꍇCC^[tF[Xڑ̃m[hID擾ăZbg
				command.setFrom(getNodeId());
			}
			syncq.add(command);
		} catch(Exception e) {
			log.warn(e);
			throw new SyncQueueException(e.getMessage());
		}
	}
	/**
	 * w̃R}h𓯊L[폜
	 * @param command 폜Ώۂ̓R}h
	 */
	public void remove(SyncCommand command) {
		syncq.remove(command);
	}
	/**
	 * 
	 * 炩ߐݒ肳ꂽC^[tF[XāĈƂ
	 * @return MR}h̃Xg
	 */
	public SyncCommand[] sync() {
		SyncCommand[] e = null;

		try {
			syncIF.sync(syncq.getAll());
			syncq.clear();
			e = syncIF.getSyncData();

			if(e != null && e.length > 0) {
				write(e.length + "̓񂪖܂");
			}
		} catch(Exception exp) {
			errorCount++;
			write("̑MɃG[܂:");
			exp.printStackTrace();
		}

		return e;
	}
	/**
	 * m[hIDԂ
	 * @return m[hID
	 */
	public String getNodeId() {
		return nodeId;
	}
	/**
	 * ̃m[hĂɑMꂽR}h
	 * @param commands MR}h̃Xg
	 */
	protected void handleAllEvents(SyncCommand[] commands) {
		if(eventListener == null) {
			// CxgXi[o^ĂȂ̂ŁCȂ
			return;
		}
		for(int cnt = 0; cnt < commands.length; cnt++) {
			DelayedSyncEvent eventObject = new DelayedSyncEvent(this, commands[cnt]);
			switch(commands[cnt].getType()) {
				case SyncCommand.COMMAND_LOCK:
					eventListener.onLock(eventObject);
					break;

				case SyncCommand.COMMAND_UNLOCK:
					eventListener.onUnlock(eventObject);
					break;

				case SyncCommand.COMMAND_FORWARD_URL:
					eventListener.onForwardURL(eventObject);
					break;

				case SyncCommand.COMMAND_UNFORWARD_URL:
					eventListener.onUnforwardURL(eventObject);
					break;

				case SyncCommand.COMMAND_SHUTDOWN:
					eventListener.onShutdown(eventObject);
					break;

				default:
					write("w肳ꂽR}hĂ܂: " + eventObject.getCommand().toString());
			}
		}
	}
}

// end of RSSSyncDaemon.java
