/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Node.java,v 1.13 2006/01/28 03:37:07 rampil Exp $
 */
package org.logical_paradox.rss.dsr.routing;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsr.routing.metrics.MetricCountException;
import org.logical_paradox.rss.dsr.routing.metrics.MetricCountingAlgorithmFactory;

import static org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry.*;

/**
 * I[o[Clbg[NɔzuĂm[h
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.13 $
 */
public class Node {
	/** K[ */
	private static final Log log = LogFactory.getLog(Node.class);

	/** m[hID */
	private String nodeId;
	/** ̃m[hɊ֘AÂĂDSR */
	private final RSSDistributedServiceRegistry dsr;
	/** ֘AÂĂm[h̃Xg */
	private ArrayList<Node> relativeNodes = new ArrayList<Node>();

	/** [eBOASY */
	private final RoutingAlgorithm algorithm;

	/**
	 * RXgN^
	 * @param dsr_ DSR
	 * @param nn m[hID
	 */
	public Node(RSSDistributedServiceRegistry dsr_, String nn) {
		nodeId = nn;
		dsr = dsr_;
		algorithm = RoutingAlgorithmFactory.getDefaultAlgorithm(this);
	}
	/**
	 * UT[rXWXgԂ
	 * @return UT[rXWXg
	 */
	public RSSDistributedServiceRegistry getRegistry() {
		return dsr;
	}
	/**
	 * m[hIDԂ
	 * @return m[hID
	 */
	public String getNodeId() {
		return nodeId;
	}

	/**
	 * m[hmr
	 * @param o rΏ
	 * @return true: / false:Ⴄ
	 */
	public boolean equals(Object o) {
		if(o == null || o instanceof Node == false) {
			return false;
		}
		Node node = (Node)o;
		return node.nodeId.equals(nodeId);
	}
	/**
	 * Ulbg[N痣E
	 */
	public void disconnect() {
		algorithm.notifyDisconnect();
	}
	/**
	 * wm[hm[hXgɑ݂邩ǂԂ
	 * @param node m[h
	 * @return true: / false:Ȃ
	 */
	public boolean contains(Node node) {
		return relativeNodes.contains(node);
	}
	/**
	 * m[hXgɑ݂SĂ̐ڑ肪C̃m[h̎QƂێĂ邩؂
	 * @return true:ێĂ / false:ێĂȂ
	 */
	public boolean isHoldByBuddies() {
		for(Iterator it = iteratorRelativeNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			if(node.contains(this) == false) {
				return false;
			}
		}
		return true;
	}
	/**
	 * HUG
	 * @param node HUG
	 * @return true: / false:s
	 */
	public boolean hug(Node node) {
		return algorithm.hug(node);
	}
	/**
	 * m[hXgɒǉ
	 * @param node ǉm[h
	 */
	public void add(Node node) {
		try {
			if(contains(node) == true) {
				log.warn("m[h[" + node.getNodeId() + "]͊ɓo^Ă邽߁Adēo^܂");
				return;
			}
			getRegistry().bind(RSS_SERVID_SERVICE_LOCATER, node.getNodeId(), node.getRegistry());
			relativeNodes.add(node);
			log.info("m[h[" + node.getNodeId() + "]ƌ܂");
		} catch (RemoteException e) {
			log.warn("m[h[" + node.getNodeId() + "]Ƃ̌Ɏs", e);
		}
	}
	/**
	 * m[hXgɈxɒǉ
	 * @param nodes ǉm[h̃Xg
	 */
	public void addAll(Collection<Node> nodes) {
		relativeNodes.addAll(nodes);
	}
	/**
	 * m[hXg폜
	 * @param node 폜m[h
	 */
	public void remove(Node node) {
		try {
			getRegistry().unbind(RSS_SERVID_SERVICE_LOCATER, node.getNodeId());
			relativeNodes.remove(node);
			log.info("m[h[" + node.getNodeId() + "]Ƃ̌܂");
		} catch (RemoteException e) {
			log.warn("m[h[" + node.getNodeId() + "]Ƃ̌Ɏs܂", e);
		}
	}
	/**
	 * m[hXg
	 */
	public void clear() {
		relativeNodes.clear();
	}
	/**
	 * 2_Ԃ̋v
	 * @param node rm[h
	 * @return ()
	 */
	public double distanceFrom(Node node) {
		// m[hǂ̂炢NێĂ邩
		int links = 5 - node.getRelativeNodes().size();
		if(links < 0) {
			links = 0;
		}
		try {
			// 2m[hԂ̋v
			double distance = MetricCountingAlgorithmFactory.getAlgorithm().count(node);
			log.trace("m[h[" + node.getNodeId() + "]Ƃ̘_I = " + distance);
			return (double)distance + links * 100;
		} catch(MetricCountException e) {
			// ʐMG[̂ŁA0ƂĂ
			log.warn("m[h[" + node.getNodeId() + "]Ƃ̃gbNvɎs", e);
			return 0;
		}
	}

	/**
	 * ̃m[hۗLĂ郊NSĕԂ
	 * @return ֘AÂĂm[h̃Xg
	 */
	public Iterator<Node> iteratorRelativeNodes() {
		return relativeNodes.iterator();
	}
	/**
	 * ̃m[hۗLĂ郊NSĕԂ
	 * ̃\bh́CDSRɒږ₢킹Ȃ
	 * @return Xg
	 */
	public List<Node> getRelativeNodes() {
		return getRelativeNodes(false);
	}
	/**
	 * ̃m[hۗLĂ郊NSĕԂ
	 * @param refresh true:DSRɖ₢킹 / false:DSRɖ₢킹Ȃ
	 * @return Xg
	 */
	public List<Node> getRelativeNodes(boolean refresh) {
		if(refresh == true) {
			// DSRɖ₢킹
			try {
				String[] services = getRegistry().services(RSS_SERVID_SERVICE_LOCATER);
				synchronized(relativeNodes) {
					ArrayList<Node> nodes = new ArrayList<Node>();
					for(int i = 0; i < services.length; i++) {
						try {
							// m[hǉ
							RSSDistributedServiceRegistry dsr = (RSSDistributedServiceRegistry)getRegistry().getService(services[i], 1);
							if(dsr != null) {
								nodes.add(new Node(dsr, dsr.getName()));
							} else {
								log.warn("DSR[" + services[i] + "]͔܂ł.");
							}
						} catch(RemoteException e) {
							log.warn("DSR[" + services[i] + "]Ƃ̒ʐMɎs܂DDSR𖳎܂:", e);
						}
					}
					relativeNodes.clear();
					relativeNodes.addAll(nodes);
				}
			} catch(RemoteException e) {
				// DSRƂ̂Ƃŉ炩̗O
				log.error("DSR[" + getNodeId() + "]Ƃ̒ʐMɗO܂Dm[h֘A͍XV܂:", e);
			}
		}
		return relativeNodes;
	}
	/**
	 * œKm[hIs
	 * ̃\bhsƁCIĂ郋[eBOASYɏ]
	 * œKm[hIȂB̌ʂƂāC̃m[hё̊֘Am[hƂ̌
	 * ԂXVBꍇɂĂ͂AIɕϓB
	 */
	public void configure() {
		algorithm.configure();
	}
}
