/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DefaultRoutingAlgorithm.java,v 1.9 2006/02/19 05:01:09 akabane Exp $
 */
package org.logical_paradox.rss.dsr.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsr.routing.metrics.Metric;

/**
 * ftHg̃[eBOASY
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class DefaultRoutingAlgorithm extends RoutingAlgorithm {
	/** K[ */
	private static final Log log = LogFactory.getLog(DefaultRoutingAlgorithm.class);

	/** œKm[hI̋Ȑ̌X */
	public static final double SLOPE_OF_CURVE = 1.125;
	/** m[hXgƂĕێœKm[h */
	public static final int MAX_FETCH_COUNT = 15;
	/** T̐[x */
	public static final int MAX_SEARCH_DEPTH = 2;

	/**
	 * RXgN^
	 * @param node m[h
	 */
	protected DefaultRoutingAlgorithm(Node node) {
		super(node);
	}

	/**
	 * œKm[hIs
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void configure() {
		// ݕRÂĂm[hAKȐ[x̃m[hXg擾ăm[hXg\
		List<Node> collectedNodeList = collectNodeList(getNode().getRelativeNodes(true), MAX_SEARCH_DEPTH);
		log.info("擾ꂽm[h: " + collectedNodeList.size());
		// HUGv𔭍s(͖̏ʂɃgtBbN𔭐̂ŁAۂɂhugȂ@l邱)
		for(Node node : collectedNodeList) {
			if(getNode().equals(node) == false && getNode().contains(node) == false) {
				node.hug(getNode());
				getNode().add(node);
			}
		}
		log.info("gbNvĂ܂");
		ArrayList<Metric> metrics = new ArrayList<Metric>();
		for(Iterator<Node> it = getNode().iteratorRelativeNodes(); it.hasNext();) {
			Node n = it.next();
			metrics.add(new Metric(getNode().distanceFrom(n), n));
		}

		// gbNl̏(߂̏)Ƀ\[g
		Collections.sort(metrics);
		int fetchPoint = 0;
		int fetchCount = 0;
		ArrayList<Node> bestNodes = new ArrayList<Node>();

		log.info("œKm[hIĂ܂");
		for(;;) {
			fetchPoint = (int)Math.pow((double)fetchCount, SLOPE_OF_CURVE);
			fetchCount++;

			if(fetchPoint >= metrics.size()) {
				break;
			}
			Metric m = metrics.get(fetchPoint);
			if(bestNodes.contains(m)) {
				// Im[h͊ɍœKm[hƂđIς݂
				continue;
			} else {
				// œKm[hƂđI
				bestNodes.add(m.getBuddy());
				log.info("ڑm[h: " + m.getBuddy().getNodeId());
			}
			if(bestNodes.size() >= MAX_FETCH_COUNT) {
				break;
			}
		}

		if(bestNodes.size() > 0) {
			// œKm[hIꂽ̂Sč폜
			getNode().getRelativeNodes().removeAll(bestNodes);		
			// cm[h(=Nؒfm[h)ɑ΂āAEʒm
			notifyDisconnect();
			// œKm[ĥ݂̃XgŃNč\
			getNode().addAll(bestNodes);
		}
	}

	/**
	 * ̃m[hƌqĂ鑼̃m[hm[hXgW
	 * w肳ꂽKwJԂs
	 * [DTŎs
	 * @param depth T̐[(1ȏ)
	 * @return Wꂽm[hXg(dƎ̃m[h܂܂Ȃ)
	 */
	protected List<Node> collectNodeList(List<Node> nodeList, int depth) {
		List<Node> nodes = new ArrayList<Node>();

		if(depth > 0) {
			// Ƃēnꂽm[hɂāCm[hXgv
			for(Node node : nodeList) {
				if(node.equals(getNode()) == false && nodes.contains(node) == false) {
					nodes.add(node);
				}
				// m[hXgǉ
				for(Node n : node.getRelativeNodes(true)) {
					if(nodes.contains(n) == false) {
						nodes.add(n);
					}
				}
				// ̊KwTʂǉ
				nodes.addAll(collectNodeList(node.getRelativeNodes(), depth-1));
			}
		}
		return nodes;
	}

	/**
	 * hug
	 * @param node hugvĂm[h
	 * @return true: / false:
	 */
	public boolean hug(Node node) {
		if(getNode().contains(node) == false) {
			getNode().add(node);
		}
		return true;
	}

	/**
	 * hugĂSẴm[hɑ΂āCUlbg[N̗Eʒm
	 */
	public void notifyDisconnect() {
		for(Iterator<Node> it = getNode().iteratorRelativeNodes(); it.hasNext();) {
			Node node = it.next();
			// ڑ̃m[hC̃m[hɊւ郊N폜
			node.remove(getNode());
			it.remove();
		}
	}
}
