/*
 * $Id: Message.java,v 1.7 2006/02/06 15:32:50 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsr;

import java.io.Serializable;
import java.util.Stack;

/**
 * DSRԂŃbZ[WۂɎgpIuWFNg
 * ̃bZ[W̃o[͑SăVA\łȂ΂ȂȂ
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class Message implements Serializable, Cloneable {
	/** VAo[WUID */
	private static final long serialVersionUID = -165920728326655367L;
	/** T[rXvgR()*/
	public static final int MSG_TYPE_CD_DISCOVER = 10;
	/** T[rXvgR(g[X)*/
	public static final int MSG_TYPE_CD_TRACE = 20;

	/** T̖ */
	private String targetName;
	/** ΏۃT[rXID */
	private int discoverType;
	/** T̐[ */
	private int traceLevel;
	/** ݂̒T[x */
	private int currentLevel;

	/** ̃bZ[WǂĂoH */
	private Stack<Route> route;

	/**
	 * RXgN^
	 */
	public Message() {
		route = new Stack<Route>();
	}

	/**
	 * Rs[RXgN^
	 * @param msg ̃bZ[W
	 */
	@SuppressWarnings("unchecked")
	public Message(Message msg) {
		route = (Stack<Route>)msg.route.clone();
		targetName = msg.targetName == null ? null : msg.targetName;
		discoverType = msg.discoverType;
		traceLevel = msg.getTraceLevel();
		currentLevel = msg.getCurrentLevel();
	}
	/**
	 * T̖̂ݒ肷
	 * @param name T̖
	 */
	public void setTargetName(String name) {
		targetName = name;
	}
	/**
	 * T̖̂Ԃ
	 * @return T̖
	 */
	public String getTargetName() {
		return targetName;
	}
	/**
	 * T̐[ݒ肷
	 * @param tl T̐[(0ȉ:)
	 */
	public void setTraceLevel(int tl) {
		traceLevel = tl;
	}
	/**
	 * T̐[Ԃ
	 * @return T̐[(0ȉ:)
	 */
	public int getTraceLevel() {
		return traceLevel;
	}
	/**
	 * ΏۃT[rXIDݒ肷
	 * @param dt ΏۃT[rXID
	 */
	public void setDiscoverType(int dt) {
		discoverType = dt;
	}
	/**
	 * ΏۃT[rXIDԂ
	 * @return ΏۃT[rXID
	 */
	public int getDiscoverType() {
		return discoverType;
	}
	/**
	 * oHǉ
	 * @param r oH
	 */
	public void push(Route r) throws AlreadyTracedException {
		route.push(r);
	}
	/**
	 * oH1Ԃ
	 * @return oH
	 */
	public Route pop() {
		return (Route)route.pop();
	}
	/**
	 * ݂̒T[x𑝉
	 */
	public void incrementLevel() {
		currentLevel++;
	}

	/**
	 * ݂̒T[xԂ
	 * @return T[x
	 */
	public int getCurrentLevel() {
		return currentLevel;
	}
}
