/*
 * $Id: RSSConfig.java,v 1.3 2006/02/06 15:32:51 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * RSSConfig
 * Tm[h/oHm[hȂǂ̊econfig߂̃NX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class RSSConfig {
	/** RtBO[V̓e */
	protected Properties prop = null;

	/**
	 * RXgN^
	 * @param fn RtBOt@C
	 */
	public RSSConfig(String fn) throws IOException, RSSIllegalConfigException {
		prop = new Properties();
		prop.load(new FileInputStream(fn));

		// ݒt@C̓emF
		String errmsg = checkResourceVariables();
		if(errmsg != null && errmsg.trim().length() > 0) {
			throw new RSSIllegalConfigException(errmsg);
		}
	}

	/**
	 * ݒt@C̓emF
	 * @return G[bZ[W
	 */
	protected abstract String checkResourceVariables();

	/**
	 * wL[̐ݒeԂ
	 * @param key L[
	 * @return e
	 */
	public String getProperty(String key) {
		if(prop.get(key) == null) {
			return null;
		} else {
			return (String)prop.get(key);
		}
	}

	/**
	 * wL[̓e𐮐ƂĎ擾
	 * @param key L[
	 * @return l
	 */
	public int getPropertyAsInt(String key) throws RSSValueFormatException, RSSNullValueException {
		String p = getProperty(key);
		if(p == null) {
			throw new RSSNullValueException();
		}

		int rc = 0;
		try {
			rc = Integer.parseInt(p);
		} catch(Exception e) {
			throw new RSSValueFormatException(e.getMessage());
		}

		return rc;
	}

	/**
	 * wL[̓eboollƂĎ擾
	 * @param key L[
	 * @return 
	 */
	public boolean getPropertyAsBool(String key) throws RSSValueFormatException, RSSNullValueException {
		String p = getProperty(key);
		if(p == null) {
			throw new RSSNullValueException();
		} else {
			p = p.toUpperCase().trim();
		}

		boolean rc = true;
		if(p.equals("ON") || p.equals("TRUE")) {
			rc = true;
		} else if(p.equals("OFF") || p.equals("FALSE")) {
			rc = false;
		} else {
			throw new RSSValueFormatException();
		}

		return rc;
	}
}

// end of RSSConfig.java
