/*
 * $Id: IPv4AddressRangeSet.java,v 1.3 2006/01/28 03:37:07 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.common.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;

/**
 * IPv4AddressRangeSet
 * IPv4x[X̃AhX͈͂̃ZbgǗNX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class IPv4AddressRangeSet extends IPAddressRangeSet {
	/**
	 * RXgN^
	 */
	public IPv4AddressRangeSet() {
	}
	/**
	 * RXgN^
	 * @param filename IPAhX͈̓Zbgt@C
	 * @throws IOException ͈̓Zbgf[^̃[hɎs
	 */
	public IPv4AddressRangeSet(String filename) throws IOException {
		super(filename);
	}
	/**
	 * RXgN^
	 * @param in IPAhX͈̓Zbgf[^ւ̓̓Xg[
	 * @throws IOException ǂݍ݂Ɏs
	 */
	public IPv4AddressRangeSet(InputStream in) throws IOException {
		super(in);
	}

	/**
	 * IPAhX쐬
	 * @param ips IPAhX()
	 * @return IPv4܂IPv6NX
	 */
	@Override
	protected IPAddress getIPAddress(String ips) throws UnknownHostException {
		return new IPv4Address(IPv4Address.getIPv4MaskPair(ips));
	}
}

// end of IPv4AddressRangeSet.java
