/*
 * $Id: IPAddressRangeSet.java,v 1.3 2006/01/26 16:27:35 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.common.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;

/**
 * IPAddressRangeSet
 * IPAhX͈͂̃ZbgǗNX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class IPAddressRangeSet {
	/** IPAhX͈̓Zbg̎ */
	protected final HashSet<IPAddress> dic = new HashSet<IPAddress>();

	/**
	 * RXgN^
	 */
	public IPAddressRangeSet() {
	}
	/**
	 * RXgN^
	 * @param filename IPAhX͈̓Zbgt@C
	 * @throws IOException ͈̓Zbgf[^̃[hɎs
	 */
	public IPAddressRangeSet(String filename) throws IOException {
		load(filename);
	}
	/**
	 * RXgN^
	 * @param in IPAhX͈̓Zbgf[^ւ̓̓Xg[
	 * @throws IOException ǂݍ݂Ɏs
	 */
	public IPAddressRangeSet(InputStream in) throws IOException {
		load(in);
	}

	/**
	 * IPAhX͈͂̈ꗗt@CȂǂ烍[h
	 * @param ranges ͈̓f[^
	 */
	public void setRanges(String[] ranges) throws UnknownHostException {
		for(int i = 0; i < ranges.length; i++) {
			dic.add(getIPAddress(ranges[i].trim()));
		}
	}
	/**
	 * IPAhX͈̓Zbg[h
	 * @param filename IPAhX͈̓Zbgt@C
	 * @throws IOException [hɎs
	 */
	public void load(String filename) throws IOException {
		load(new FileInputStream(filename));
	}
	/**
	 * w肳ꂽ̓Xg[IPAhX͈̓Zbg荞
	 * @param in ̓Xg[
	 * @throws IOException ̓Xg[̎荞݂Ɏs
	 */
	public void load(InputStream in) throws IOException {
		BufferedReader br = new BufferedReader(new InputStreamReader(in));

		String line = null;
		try {
			while((line = br.readLine()) != null) {
				dic.add(getIPAddress(line));
			}
		} catch(UnknownHostException ue) {
			throw new IOException(ue.getMessage());
		}
		br.close();
	}

	/**
	 * IPAhX쐬(̃NX쐬邩̓TuNXŎ
	 * @param ips IPAhX()
	 * @return IPv4܂IPv6NX
	 */
	protected abstract IPAddress getIPAddress(String ips) throws UnknownHostException;

	/**
	 * w肳ꂽIPAhXɊYIPAhX͈̓R[h݂邩ǂ𒲂ׂ
	 * @param ipa IPAhX
	 * @return true:܂܂Ă / false:܂܂ĂȂ
	 */
	public boolean includes(InetAddress ipa) {
		Iterator it = dic.iterator();
		while(it.hasNext()) {
			IPAddress range = (IPAddress)it.next();
			if(range.includes(ipa)) {
				return true;		// 
			}
		}

		return false;
	}
}

// end of IPAddressRangeSet.java
