/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

public class ByteStreamConverter {
    public static final byte[] convert(byte b) {
        return new byte[]{b};
    }

    public static final byte[] convert(short s) {
        byte a = (byte)(s & 0xFF);
        byte b = (byte)(s >> 8 & 0xFF);
        return new byte[]{b, a};
    }

    public static final byte[] convert(int i) {
        byte a = (byte)(i & 0xFF);
        byte b = (byte)(i >> 8 & 0xFF);
        byte c = (byte)(i >> 16 & 0xFF);
        byte d = (byte)(i >> 24 & 0xFF);
        return new byte[]{d, c, b, a};
    }

    public static final byte[] convert(long l) {
        byte a = (byte)(l & 0xFFL);
        byte b = (byte)(l >> 8 & 0xFFL);
        byte c = (byte)(l >> 16 & 0xFFL);
        byte d = (byte)(l >> 24 & 0xFFL);
        byte e = (byte)(l >> 32 & 0xFFL);
        byte f = (byte)(l >> 40 & 0xFFL);
        byte g = (byte)(l >> 48 & 0xFFL);
        byte h = (byte)(l >> 56 & 0xFFL);
        return new byte[]{h, g, f, e, d, c, b, a};
    }

    public static int getInt(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static long getLong(byte[] b) {
        return ((long)b[0] & 0xFFL) << 56 | ((long)b[1] & 0xFFL) << 48 | ((long)b[2] & 0xFFL) << 40 | ((long)b[3] & 0xFFL) << 32 | ((long)b[4] & 0xFFL) << 24 | ((long)b[5] & 0xFFL) << 16 | ((long)b[6] & 0xFFL) << 8 | (long)b[7] & 0xFFL;
    }
}

