/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionManager;

public class SessionUnbounder
extends Thread {
    private int interval;
    private boolean exitf = false;
    private SessionManager manager;

    SessionUnbounder(SessionManager mngr, int itv) {
        this.interval = itv;
        this.manager = mngr;
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (true) {
                if (this.exitf) {
                    throw new InterruptedException();
                }
                this.checkAllSessions();
                SessionUnbounder.sleep(this.interval);
            }
        }
        catch (InterruptedException ie) {
            this.shutdown();
            return;
        }
    }

    public void done() {
        this.exitf = true;
    }

    private void shutdown() {
        this.done();
        this.manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAllSessions() {
        Map sessions = this.manager.getAllSessions();
        ArrayList<Session> inactives = new ArrayList<Session>();
        Map map = sessions;
        synchronized (map) {
            Iterator it = sessions.keySet().iterator();
            while (it.hasNext()) {
                String sessionId = (String)it.next();
                try {
                    Session session = this.manager.getSession(sessionId, false);
                    if (session == null || session.isActive()) continue;
                    inactives.add(session);
                }
                catch (IllegalSessionStateException e) {}
            }
            this.manager.removeAllSessions(inactives);
        }
    }
}

