/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.session.SessionContext;
import org.logical_paradox.common.util.AttributeChangeEvent;
import org.logical_paradox.common.util.AttributeChangeListener;

public class SessionContextTest
extends TestCase {
    public SessionContextTest(String arg0) {
        super(arg0);
    }

    public void testAttributeInOutWithoutListener() {
        SessionContext context = new SessionContext();
        Hashtable ht = new Hashtable();
        ArrayList al = new ArrayList();
        Long l = new Long(10000L);
        context.setAttribute("\u3042\u3042\u3042\u3042\u6f22\u5b57\u3082OK", ht);
        context.setAttribute("+*=-~[]", al);
        context.setAttribute("", l);
        Assert.assertTrue((ht == context.getAttribute("\u3042\u3042\u3042\u3042\u6f22\u5b57\u3082OK") ? 1 : 0) != 0);
        Assert.assertTrue((al == context.getAttribute("+*=-~[]") ? 1 : 0) != 0);
        Assert.assertTrue((l == context.getAttribute("") ? 1 : 0) != 0);
        context.setAttribute("", ht);
        Assert.assertTrue((ht == context.getAttribute("") ? 1 : 0) != 0);
    }

    public void testAttributeInOutWithListener() {
        AttributeChangeListenerImpl listener = new AttributeChangeListenerImpl();
        SessionContext context = new SessionContext();
        Hashtable ht = new Hashtable();
        ArrayList al = new ArrayList();
        Long l = new Long(10000L);
        context.setAttributeChangeListener("", listener);
        context.setAttributeChangeListener("\u3042\u3042\u3042\u3042\u6f22\u5b57\u3082OK", listener);
        context.setAttribute("\u3042\u3042\u3042\u3042\u6f22\u5b57\u3082OK", ht);
        Assert.assertTrue((ht == listener.getPreReason() ? 1 : 0) != 0);
        Assert.assertTrue((ht == listener.getPostReason() ? 1 : 0) != 0);
        Assert.assertTrue((context == listener.getPreSource() ? 1 : 0) != 0);
        Assert.assertTrue((context == listener.getPostSource() ? 1 : 0) != 0);
        context.setAttribute("+*=-~[]", al);
        context.setAttribute("", l);
        Assert.assertTrue((l == listener.getPreReason() ? 1 : 0) != 0);
        Assert.assertTrue((context == listener.getPreSource() ? 1 : 0) != 0);
        Assert.assertTrue((l == listener.getPostReason() ? 1 : 0) != 0);
        Assert.assertTrue((context == listener.getPostSource() ? 1 : 0) != 0);
    }

    class AttributeChangeListenerImpl
    implements AttributeChangeListener {
        private Object preReason;
        private Object preSrc;
        private Object postReason;
        private Object postSrc;
        private boolean preChangeRan = false;
        private boolean postChangedRan = false;

        AttributeChangeListenerImpl() {
        }

        public Object getPreReason() {
            return this.preReason;
        }

        public Object getPreSource() {
            return this.preSrc;
        }

        public Object getPostReason() {
            return this.postReason;
        }

        public Object getPostSource() {
            return this.postSrc;
        }

        public boolean isPreChangeRan() {
            return this.preChangeRan;
        }

        public boolean isPostChangeRan() {
            return this.postChangedRan;
        }

        public void preChange(AttributeChangeEvent e) {
            this.preReason = e.getReason();
            this.preSrc = e.getSource();
            this.preChangeRan = true;
        }

        public void postChanged(AttributeChangeEvent e) {
            this.postReason = e.getReason();
            this.postSrc = e.getSource();
            this.postChangedRan = true;
        }
    }
}

