/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.util.Cache;

public abstract class AvailableList {
    protected final String filename;
    protected final Cache cache;

    public AvailableList(String filename) {
        this(filename, 0);
    }

    public AvailableList(String filename, int size) {
        this.filename = filename;
        this.cache = this.createCache(size);
        try {
            this.reload();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Cache createCache(int size) {
        return new Cache(size);
    }

    public void reload() throws IOException {
        byte[] buf = new byte[(int)this.getFileSize()];
        InputStream in = this.getInputStream();
        in.read(buf);
        in.close();
        ByteBuffer buffer = ByteBuffer.allocate(buf.length).order(ByteOrder.BIG_ENDIAN);
        buffer.rewind();
        buffer.put(buf);
        buffer.rewind();
        this.restore(buffer);
    }

    protected abstract void restore(ByteBuffer var1) throws IOException;

    public abstract void flush() throws IOException;

    public Cache getCache() {
        return this.cache;
    }

    protected InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.filename));
    }

    protected OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.filename));
    }

    protected long getFileSize() throws IOException {
        return new File(this.filename).length();
    }
}

