/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeManipulationException;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.btree.BtreeResultSet;

public class BtreeSession {
    private final Btree _master;

    protected BtreeSession(Btree master) {
        this._master = master;
    }

    public BtreeSession open(String filename) throws BtreeException {
        this._master.open(filename);
        return this;
    }

    public BtreeSession open(String filename, int cachesize) throws BtreeException {
        this._master.open(filename, cachesize);
        return this;
    }

    public void close() throws BtreeException {
        this._master.close();
    }

    public boolean isClosed() {
        return this._master.isClosed();
    }

    public BtreePage getPage(long pageno) throws BtreeException {
        return this._master.getPage(pageno);
    }

    public BtreePage getPage() throws BtreeException {
        return this._master.getPage(-1L);
    }

    public BtreeKey newKey(Object o) throws BtreeException {
        return this._master.newKey(o);
    }

    public void insert(BtreeKey key) throws BtreeException, BtreeManipulationException {
        this._master.insert(key);
    }

    public void delete(BtreeKey key) throws BtreeException {
        this._master.delete(key);
    }

    public void update(BtreeKey key) throws BtreeException {
        this._master.update(key);
    }

    public BtreeResultSet find(BtreeKey key) throws BtreeException {
        return this._master.find(key);
    }
}

