/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.io.CommonRandomAccessFileDelegator;
import org.logical_paradox.common.io.RandomAccessFileDelegator;

public class BtreeFile {
    public static final String FILENAME = "btreefile.filename";
    public static final String MAGIC_NUMBER = "btreefile.magicnumber";
    public static final String MAJOR_VERSION = "btreefile.majorversion";
    public static final String MINOR_VERSION = "btreefile.minorversion";
    public static final String HEADER_SIZE = "btreefile.headersize";
    public static final String ORDER = "btreefile.order";
    public static final String KEYSIZE = "btreefile.keysize";
    public static final String ROOT_PAGE = "btreefile.rootpage";
    public static final String MAX_ASSIGNED_PAGE = "btreefile.maxassignedpage";
    protected byte[] _magicNumber = new byte[4];
    protected byte _majorVersion;
    protected byte _minorVersion;
    protected int _sizeOfHeader;
    protected long _rootPageNo;
    protected int _order;
    protected int _keysize;
    protected long _maxAssignedPageNo;
    protected BtreeFactory _factory = null;
    protected RandomAccessFileDelegator _btfile;
    protected BtreeAvailableList _fragment;

    protected BtreeFile() {
    }

    public BtreeFile(BtreeFactory factory, Properties prop) throws BtreeException {
        this._factory = factory;
        this.setProperty(prop);
        try {
            this._btfile = this.openPhysicalFile(prop.getProperty(FILENAME));
            this._fragment = this._factory.getBtreeAvailableList(String.valueOf(prop.getProperty(FILENAME)) + ".fgm");
        }
        catch (Exception e) {
            throw new BtreeException(e.getMessage());
        }
    }

    protected RandomAccessFileDelegator openPhysicalFile(String filename) throws Exception {
        return new CommonRandomAccessFileDelegator(filename, "rw");
    }

    protected void setProperty(Properties prop) throws BtreeException {
        try {
            String maxAssignedPage;
            this._btfile = this.openPhysicalFile(prop.getProperty(FILENAME));
            byte[] magicNumber = prop.getProperty(MAGIC_NUMBER).getBytes();
            this._magicNumber[0] = magicNumber[0];
            this._magicNumber[1] = magicNumber[1];
            this._magicNumber[2] = magicNumber[2];
            this._magicNumber[3] = magicNumber[3];
            this.setVersion(Integer.parseInt(prop.getProperty(MAJOR_VERSION)), Integer.parseInt(prop.getProperty(MINOR_VERSION)));
            this._sizeOfHeader = Integer.parseInt(prop.getProperty(HEADER_SIZE));
            this._order = Integer.parseInt(prop.getProperty(ORDER));
            this._keysize = Integer.parseInt(prop.getProperty(KEYSIZE));
            String rootpage = prop.getProperty(ROOT_PAGE);
            if (rootpage != null) {
                this._rootPageNo = Long.parseLong(rootpage);
            }
            if ((maxAssignedPage = prop.getProperty(MAX_ASSIGNED_PAGE)) != null) {
                this._maxAssignedPageNo = Long.parseLong(maxAssignedPage);
            }
        }
        catch (Exception e) {
            throw new BtreeException("\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u9593\u9055\u3044\u304c\u3042\u308a\u307e\u3059");
        }
    }

    public long getMaxAssignedPageNo() {
        return this._maxAssignedPageNo;
    }

    public void close() throws IOException {
        try {
            this._fragment.flush();
            this.flush();
        }
        catch (BtreeException be) {
            throw new IOException(be.getMessage());
        }
        this._btfile.close();
        this._btfile = null;
    }

    public boolean isClosed() {
        return this._btfile == null;
    }

    public long getRootPageNo() {
        return this._rootPageNo;
    }

    public String getMagicNumber() {
        try {
            return new String(this._magicNumber, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public void setMagicNumber(byte[] magicNumber) throws IllegalArgumentException {
        if (magicNumber == null || magicNumber.length != 4) {
            throw new IllegalArgumentException("\u30de\u30b8\u30c3\u30af\u30ca\u30f3\u30d0\u30fc\u306f\u8981\u7d20\u65704\u306e\u30d0\u30a4\u30c8\u914d\u5217\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this._magicNumber = new byte[magicNumber.length];
        System.arraycopy(magicNumber, 0, this._magicNumber, 0, this._magicNumber.length);
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void setVersion(int major, int minor) {
        this._majorVersion = (byte)major;
        this._minorVersion = (byte)minor;
    }

    public int getHeaderSize() {
        return this._sizeOfHeader;
    }

    public long length() {
        try {
            return this._btfile.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void reload() throws IOException, BtreeException {
        this._btfile.seek(6L);
        try {
            this._sizeOfHeader = this._btfile.readInt();
            this._btfile.seek(0L);
            byte[] headerBlock = new byte[this._sizeOfHeader];
            this._btfile.readFully(headerBlock);
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(headerBlock));
            this._magicNumber[0] = din.readByte();
            this._magicNumber[1] = din.readByte();
            this._magicNumber[2] = din.readByte();
            this._magicNumber[3] = din.readByte();
            this._majorVersion = din.readByte();
            this._minorVersion = din.readByte();
            this._sizeOfHeader = din.readInt();
            this._rootPageNo = din.readLong();
            this._maxAssignedPageNo = din.readLong();
            din.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new BtreeException(ioe.getMessage());
        }
    }

    public void flush() throws IOException, BtreeException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream(this._sizeOfHeader);
        DataOutputStream dos = new DataOutputStream(bao);
        try {
            dos.write(this._magicNumber, 0, this._magicNumber.length);
            dos.writeByte(this._majorVersion);
            dos.writeByte(this._minorVersion);
            dos.writeInt(this._sizeOfHeader);
            dos.writeLong(this._rootPageNo);
            dos.writeLong(this._maxAssignedPageNo);
            byte[] headerBlock = new byte[this._sizeOfHeader];
            byte[] storedByteArray = bao.toByteArray();
            System.arraycopy(storedByteArray, 0, headerBlock, 0, storedByteArray.length);
            this._btfile.seek(0L);
            this._btfile.write(headerBlock);
        }
        catch (ArrayIndexOutOfBoundsException be) {
            be.printStackTrace();
            throw new BtreeException(be.getMessage());
        }
    }

    public BtreePage newPage() throws BtreeException {
        BtreePage btp = null;
        BtreeFile btreeFile = this;
        synchronized (btreeFile) {
            long unusedPageNo = this.findEmptyPage();
            if (unusedPageNo > -1L) {
                btp = this.getPage(unusedPageNo);
                btp.init();
                btp.setPageNo(unusedPageNo);
                btp.setEnabled(true);
                return btp;
            }
            ++this._maxAssignedPageNo;
            btp = new BtreePage(this._factory, this._maxAssignedPageNo);
            if (this._maxAssignedPageNo == 1L && this._rootPageNo <= 0L) {
                this._rootPageNo = this._maxAssignedPageNo;
            }
            try {
                this._btfile.seek(this._btfile.length());
                this._btfile.write(btp.getByteStream());
            }
            catch (Exception ioe) {
                --this._maxAssignedPageNo;
                throw new BtreeException("\u51fa\u529b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f");
            }
        }
        return btp;
    }

    protected BtreePage getPage(long pageno) throws BtreeException {
        int pageSize = this.getPageSize();
        if (pageno <= 0L && (pageno = this.getRootPageNo()) <= 0L) {
            return null;
        }
        long seekp = (long)pageSize * (pageno - 1L) + (long)this.getHeaderSize();
        try {
            this._btfile.seek(seekp);
            byte[] pageStream = new byte[pageSize];
            this._btfile.read(pageStream);
            BtreePage btpage = new BtreePage(this._factory, pageno, pageStream);
            return btpage;
        }
        catch (IOException ioe) {
            throw new BtreeException(ioe.getMessage());
        }
    }

    protected int getPageSize() {
        int keyByteSize = this._keysize;
        return keyByteSize * this._order + 8 * (this._order + 1) + 4;
    }

    public long calcSeekPointer(long pageno) {
        return (long)this.getPageSize() * (pageno - 1L) + (long)this.getHeaderSize();
    }

    public void replacePage(BtreePage btp) throws BtreeException {
        byte[] page = btp.getByteStream();
        long seekp = this.calcSeekPointer(btp.getPageNo());
        try {
            this._btfile.seek(seekp);
            this._btfile.write(btp.getByteStream());
            if (!btp.isEnabled()) {
                this._fragment.getCache().add((Object)new Long(btp.getPageNo()));
                btp.setPageNo(-1L);
            }
        }
        catch (IOException ioe) {
            throw new BtreeException(ioe.getMessage());
        }
    }

    protected synchronized void replaceRootPageNo(long l) throws BtreeException {
        long before = this._rootPageNo;
        try {
            this._rootPageNo = l;
        }
        catch (Exception e) {
            this._rootPageNo = before;
            e.printStackTrace();
            throw new BtreeException(e.getMessage());
        }
    }

    protected synchronized long findEmptyPage() throws BtreeException {
        Long l = (Long)this._fragment.getCache().getOne();
        return l == null ? -1L : l;
    }
}

