/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.koike.rss.index.MySQLInterfaceConstant;
import org.logical_paradox.koike.rss.index.MySQLInvertedIndexRegistrar;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;

public class MySQLIndexAccessor
implements IndexAccessor,
MySQLInterfaceConstant {
    private static final Log log;
    private Connection con;
    private PreparedStatement pstmtRemove;
    private PreparedStatement pstmtQuery;
    private DataFilter filter;
    private MySQLInvertedIndexRegistrar registrar;
    private final Base64 base64 = new Base64();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.logical_paradox.koike.rss.index.MySQLIndexAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public MySQLIndexAccessor() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        ResourceBundle rb = ResourceBundle.getBundle("mysql");
        Class.forName(rb.getString("jdbc.driver.class"));
        this.con = DriverManager.getConnection(rb.getString("index.connect.str"));
        this.con.setAutoCommit(true);
        try {
            this.pstmtRemove = this.con.prepareStatement(rb.getString("index.remove.sql"));
            this.pstmtQuery = this.con.prepareStatement(rb.getString("index.search.sql"));
        }
        catch (SQLException se) {
            if (this.pstmtRemove != null) {
                this.pstmtRemove.close();
                this.pstmtRemove = null;
            }
            if (this.pstmtQuery != null) {
                this.pstmtQuery.close();
                this.pstmtQuery = null;
            }
            if (this.con != null) {
                this.con.close();
            }
            throw se;
        }
        this.filter = DataFilterFactory.getFilter((int)1);
        this.registrar = new MySQLInvertedIndexRegistrar(this.con);
        this.registrar.start();
    }

    public boolean isClosed() {
        return this.con == null;
    }

    public void close() throws IndexAccessException {
        if (this.registrar != null) {
            this.registrar.shutdown();
            try {
                try {
                    this.registrar.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.registrar = null;
                throw throwable;
            }
            Object var2_5 = null;
            this.registrar = null;
        }
        if (this.con != null) {
            try {
                if (this.pstmtRemove != null) {
                    this.pstmtRemove.close();
                    this.pstmtRemove = null;
                }
                if (this.pstmtQuery != null) {
                    this.pstmtQuery.close();
                    this.pstmtQuery = null;
                }
                this.con.close();
                this.con = null;
            }
            catch (SQLException se) {
                throw new IndexAccessException((Exception)se);
            }
        }
    }

    public void addTerm(String digest, Term[] term) throws IndexAccessException {
        this.registrar.add(digest, term);
    }

    public Object removeTerm(String key) throws IndexAccessException {
        try {
            this.pstmtRemove.setString(1, key);
            this.pstmtRemove.executeUpdate();
            return null;
        }
        catch (SQLException se) {
            throw new IndexAccessException((Exception)se);
        }
    }

    public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
        KoikeIndexResultSet kirs = new KoikeIndexResultSet();
        double begin = System.currentTimeMillis();
        ResultSet rs = null;
        try {
            try {
                String term = new String(this.base64.encode(key.getBytes()));
                this.pstmtQuery.setString(1, term);
                rs = this.pstmtQuery.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                    long docno = rs.getLong("docno");
                    String location = rs.getString("location");
                    if (StringUtils.isEmpty((String)location)) continue;
                    kirs = this.createInvertedIndex(kirs, (int)docno, location);
                }
                log.trace((Object)("term [" + key + "] is found in [" + cnt + "] rows."));
            }
            catch (SQLException se) {
                throw new IndexAccessException((Exception)se);
            }
            catch (Exception e) {
                throw new IndexAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException se) {
                throw new IndexAccessException((Exception)se);
            }
            throw throwable;
        }
        Object var11_14 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException se) {
            throw new IndexAccessException((Exception)se);
        }
        double fin = System.currentTimeMillis();
        log.trace((Object)("\u691c\u7d22\u6642\u9593: " + (fin - begin) / 1000.0 + "sec."));
        return kirs;
    }

    protected KoikeIndexResultSet createInvertedIndex(KoikeIndexResultSet rs, int docno, String value) {
        if (rs == null) {
            rs = new KoikeIndexResultSet();
        }
        String nodeId = "";
        String[] values = value.split(",");
        int i = 0;
        while (i < values.length) {
            int pos = Integer.parseInt(values[i]);
            int blkno = docno / 64;
            long documents = 1L << (int)((long)(docno - blkno * 64));
            InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
            if (iidx != null) {
                documents |= iidx.getDocumentAvailability();
            } else {
                iidx = new InvertedIndex(nodeId, blkno, 0L);
            }
            iidx.setDocumentAvailability(documents, false);
            iidx.addLocation(new Location(nodeId, docno, pos));
            rs.addInvertedIndex(iidx);
            ++i;
        }
        return rs;
    }
}

