/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

import java.util.Iterator;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.common.util.CacheCollection;

public class PriorityCache
extends Cache {
    public static final int GREATER_FIRST = 1;
    public static final int LESS_FIRST = 0;
    private final int sortOrder;

    public PriorityCache() {
        this.sortOrder = 1;
    }

    public PriorityCache(int size) {
        super(size);
        this.sortOrder = 1;
    }

    public PriorityCache(int size, int order) {
        super(size);
        this.sortOrder = order;
    }

    public Object add(Object o) {
        return this.add((Comparable)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object add(Comparable o) {
        Object rc = null;
        CacheCollection cacheCollection = this.collection;
        synchronized (cacheCollection) {
            int idx;
            if (this.collection.size() == this.limit) {
                rc = this.cacheOut();
            }
            if ((idx = this.findInsertableIndex(o)) == -1) {
                this.collection.add(o);
            } else {
                this.collection.add(idx, o);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findInsertableIndex(Comparable o) {
        int idx = 0;
        PriorityCache priorityCache = this;
        synchronized (priorityCache) {
            Iterator it = this.collection.iterator();
            while (it.hasNext()) {
                switch (this.sortOrder) {
                    case 1: {
                        if (o.compareTo((Comparable)it.next()) <= 0) break;
                        return idx;
                    }
                    case 0: {
                        if (o.compareTo((Comparable)it.next()) >= 0) break;
                        return idx;
                    }
                    default: {
                        throw new IllegalArgumentException("\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u512a\u5148\u9806\u4f4d\u30aa\u30fc\u30c0\u30fc\u304c\u304a\u304b\u3057\u3044:" + this.sortOrder);
                    }
                }
                ++idx;
            }
        }
        return -1;
    }
}

