/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.phalanx.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;

import javax.xml.bind.JAXBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.KoikeConfigException;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchEngine;
import org.logical_paradox.koike.core.search.SearchResult;
import org.logical_paradox.phalanx.SearchException;
import org.logical_paradox.phalanx.SearchLogic;
import org.logical_paradox.phalanx.binding.condition.AndType;
import org.logical_paradox.phalanx.binding.condition.Condition;
import org.logical_paradox.phalanx.binding.condition.OrType;
import org.logical_paradox.phalanx.binding.resultset.ObjectFactory;
import org.logical_paradox.phalanx.binding.resultset.RecordType;
import org.logical_paradox.phalanx.binding.resultset.ResultSet;
import org.logical_paradox.phalanx.binding.resultset.SiteType;

/**
 * N-gramgpSWbN
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.14 $
 */
public class NgramFTSSearchLogic implements SearchLogic {
	/** K[ */
	private static final Log log = LogFactory.getLog(NgramFTSSearchLogic.class);

	/** 'koike'pRtBOt@C */
	public static final String KOIKE_CONFIG_FILENAME = "koike.conf";

	/** T[`GW */
	private SearchEngine searchEngine;

	/**
	 * s
	 * @param condition 
	 * @param configDir RtBOt@Ci[fBNg
	 * @return ʃZbg
	 * @throws SearchException ɎsۂɔO
	 */
	public ResultSet search(Condition condition, String configDir) throws SearchException, JAXBException {
		// SAvP[V̏
		// ͂Ƃ肠APT[o[őSVXeғ
		try {
			if(searchEngine == null) {
				loadSearchEngine(configDir);
			}
			SearchResult sr = searchEngine.search(createSearchCondition(condition));
			return createResultSet(sr);
		} catch(Exception e) {
			log.error(e);
			throw new SearchException(e.getMessage());
		}
	}
	/**
	 * ʂϊĕԂ
	 * @param sr GW̉
	 * @return phalanxƂẲ
	 * @throws JAXBException ʕωɔO
	 */
	protected ResultSet createResultSet(SearchResult sr) throws JAXBException {
		ObjectFactory factory = new ObjectFactory();
		ResultSet rs = factory.createResultSet();

		if(sr == null || sr.getResultSet().length == 0) {
			rs.setHits(0);
			return rs;
		}
		rs.setHits(sr.getHits());
		org.logical_paradox.koike.core.search.ResultSet[] results = sr.getResultSet();
		for(int i = 0; i < results.length; i++) {
			RecordType record = factory.createRecordType();
			SiteType site = factory.createSiteType();
			site.setName(results[i].getSiteName());
			site.setUrl(results[i].getUrl());
			site.setSummary(results[i].getSummary());
			site.setTitle(results[i].getDocumentTitle());
			record.setSite(site);
			record.setDocumentType("html");
			record.setPriority(5);
			record.setDisabled(false);

			rs.getRecord().add(record);
		}

		return rs;
	}
	/**
	 * WbN̎ʎqԂ
	 * @return ʎq
	 */
	public String getLogicIdentifier() {
		return "FULL TEXT SEARCH LOGIC USING N-GRAM TERMS";
	}
	/**
	 * ϊ
	 * @param condition tgGhVXe瑗MĂ
	 * @return GWɑ΂ēn
	 */
	protected SearchCondition createSearchCondition(Condition condition) {
		// koikě0IWł邽߁C-1
		int startIndex = condition.getStartindex().intValue() -1;
		int endIndex = condition.getEndindex().intValue() -1;
		int dispnum = endIndex - startIndex + 1;

		SearchCondition searchCondition = new SearchCondition();
		searchCondition.setStartp(startIndex < 0 ? 0 : startIndex);
		searchCondition.setDispnum(dispnum < 0 ? 0 : dispnum);

		// AND̎荞
		for(Iterator it = condition.getAnd().iterator(); it.hasNext();) {
			AndType and = (AndType)it.next();
			searchCondition.addChildNode(buildAndType(new Element(Element.TYPE_AND), and));
		}
		// OR̎荞
		for(Iterator it = condition.getOr().iterator(); it.hasNext();) {
			OrType or = (OrType)it.next();
			searchCondition.addChildNode(buildOrType(new Element(Element.TYPE_OR), or));
		}
		return searchCondition;
	}
	/**
	 * AND荞
	 * @param element ̌IuWFNg
	 * @param and AND
	 * @return ꂽvf
	 */
	protected Element buildAndType(Element element, AndType and) {
		// AND̎荞
		for(Iterator it = and.getAnd().iterator(); it.hasNext();) {
			element.addChildNode(buildAndType(new Element(Element.TYPE_AND), (AndType)it.next()));
		}
		// OR̎荞
		for(Iterator it = and.getOr().iterator(); it.hasNext();) {
			element.addChildNode(buildOrType(new Element(Element.TYPE_OR), (OrType)it.next()));
		}
		// TERM̎荞
		for(Iterator it = and.getTerm().iterator(); it.hasNext();) {
			String token = (String)it.next();
			element.addChildNode(new Element(Element.TYPE_TERM, token));
		}

		return element;
	}
	/**
	 * OR荞
	 * @param element ̌IuWFNg
	 * @param or OR
	 * @return ꂽvf
	 */
	protected Element buildOrType(Element element, OrType or) {
		// AND̎荞
		for(Iterator it = or.getAnd().iterator(); it.hasNext();) {
			element.addChildNode(buildAndType(new Element(Element.TYPE_AND), (AndType)it.next()));
		}
		// OR̎荞
		for(Iterator it = or.getOr().iterator(); it.hasNext();) {
			element.addChildNode(buildOrType(new Element(Element.TYPE_OR), (OrType)it.next()));
		}
		// TERM̎荞
		for(Iterator it = or.getTerm().iterator(); it.hasNext();) {
			try {
				element.addChildNode(new Element(Element.TYPE_TERM, new String(((String)it.next()).getBytes("utf-8"))));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}

		return element;
	}
	/**
	 * T[`GW[hD
	 * @param configDir RtBOt@Ci[fBNg
	 */
	protected void loadSearchEngine(String configDir) throws FileNotFoundException, IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, KoikeConfigException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
		// koikeRtBO[Ṽ[h
		Properties pr = new Properties();
		pr.load(new FileInputStream(configDir + File.separator + KOIKE_CONFIG_FILENAME));
		KoikeConfig config = new KoikeConfig(pr);

		searchEngine = config.getSearchEngine();
	}
}
