/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

import java.util.Iterator;
import org.logical_paradox.common.util.CacheCollection;

public class Cache {
    protected int limit;
    protected CacheCollection collection;

    public Cache() {
        this(0);
    }

    public Cache(int size) {
        this.limit = size;
        this.collection = new CacheCollection();
    }

    public Iterator iterator() {
        return new CacheIterator(this);
    }

    protected void setCacheCollection(CacheCollection c) {
        this.collection = c;
    }

    public synchronized Object getOne() {
        return this.collection.removeFirst();
    }

    protected Object cacheOut() {
        return this.getOne();
    }

    public Object add(Object o) {
        Object rc = null;
        CacheCollection cacheCollection = this.collection;
        synchronized (cacheCollection) {
            if (this.collection.size() == this.limit) {
                rc = this.cacheOut();
            }
            this.collection.add(o);
        }
        return rc;
    }

    public synchronized boolean remove(Object o) {
        return this.collection.remove(o);
    }

    public synchronized int size() {
        return this.collection.size();
    }

    private class CacheIterator
    implements Iterator {
        private final Cache cache;

        CacheIterator(Cache c) {
            this.cache = c;
        }

        public void remove() {
            Cache cache = this.cache;
            synchronized (cache) {
                this.cache.getOne();
            }
        }

        public boolean hasNext() {
            Cache cache = this.cache;
            synchronized (cache) {
                return this.cache.size() > 0;
            }
        }

        public Object next() {
            Cache cache = this.cache;
            synchronized (cache) {
                return this.cache.getOne();
            }
        }
    }
}

