/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionManager;

public class SessionManagerTest
extends TestCase {
    public SessionManagerTest(String arg0) {
        super(arg0);
    }

    public void testCreateNewSession() throws IllegalSessionStateException {
        Session session;
        SessionManager manager = new SessionManager();
        ArrayList<Session> sessions = new ArrayList<Session>();
        int i = 0;
        while (i < 100) {
            sessions.add(manager.getSession());
            ++i;
        }
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            session = (Session)it.next();
            Assert.assertEquals((boolean)true, (boolean)manager.isExists(session.getSessionId()));
            manager.removeSession(session.getSessionId());
        }
        it = sessions.iterator();
        while (it.hasNext()) {
            session = (Session)it.next();
            Assert.assertEquals((boolean)false, (boolean)manager.isExists(session.getSessionId()));
        }
    }

    public void testContinueSession() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg");
        Assert.assertFalse((boolean)"abcdefg".equals(session.getSessionId()));
        Session newSession = manager.getSession(session.getSessionId());
        Assert.assertNotNull((Object)newSession);
        Assert.assertTrue((newSession == session ? 1 : 0) != 0);
    }

    public void testContinueSessionWithCreate() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg", true);
        Assert.assertNotNull((Object)session);
    }

    public void testContinueSessionWithoutCreate() throws IllegalSessionStateException {
        SessionManager manager = new SessionManager();
        Session session = manager.getSession("abcdefg", false);
        Assert.assertNull((Object)session);
    }
}

