/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.net.ReadWriteBuffer;

public class ReadWriteBufferTest
extends TestCase {
    public void testReadWriteWithoutExpand() {
        ReadWriteBuffer rwb = new ReadWriteBuffer();
        rwb.write("ABCDEFG");
        byte[] buf = new byte["ABCDEFG".length()];
        Assert.assertEquals((int)7, (int)rwb.read(buf));
        Assert.assertEquals((String)"ABCDEFG", (String)new String(buf));
    }

    public void testReadError() {
        ReadWriteBuffer rwb = new ReadWriteBuffer(10);
        Assert.assertEquals((int)-1, (int)rwb.read());
        rwb.write(new byte[]{1, 2, 3, 4, 5});
        int i = 0;
        while (i < 5) {
            Assert.assertTrue((-1 != rwb.read() ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertEquals((int)-1, (int)rwb.read());
        byte[] buf = new byte[4];
        rwb.write(new byte[]{11, 12});
        Assert.assertEquals((int)2, (int)rwb.read(buf));
        Assert.assertEquals((int)11, (int)buf[0]);
        Assert.assertEquals((int)12, (int)buf[1]);
        Assert.assertEquals((int)0, (int)buf[2]);
        Assert.assertEquals((int)0, (int)buf[3]);
        Assert.assertEquals((int)-1, (int)rwb.read());
    }

    public void testWriteWithExpand() {
        ReadWriteBuffer rwb = new ReadWriteBuffer(4);
        rwb.write("123456789");
        byte[] buf = new byte["123456789".length()];
        Assert.assertEquals((int)9, (int)rwb.read(buf));
        Assert.assertEquals((String)"123456789", (String)new String(buf));
    }

    public void testReadWithReduce() {
        ReadWriteBuffer rwb = new ReadWriteBuffer(4);
        int i = 0;
        while (i < 5) {
            rwb.write("12345678901234567890");
            byte[] buf = new byte[13];
            Assert.assertEquals((int)13, (int)rwb.read(buf));
            Assert.assertEquals((String)"1234567890123", (String)new String(buf));
            rwb.write("abcdefg");
            buf = new byte[14];
            Assert.assertEquals((int)14, (int)rwb.read(buf));
            Assert.assertEquals((String)"4567890abcdefg", (String)new String(buf));
            ++i;
        }
    }
}

