/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.lang;

import java.io.Serializable;
import org.logical_paradox.common.io.ByteStream;

public class VariableFormatNumber
extends Number
implements Serializable,
ByteStream {
    private final long value;

    public VariableFormatNumber(byte[] bstream) {
        this.value = this.byteStreamToLongValue(bstream, 0);
    }

    public VariableFormatNumber(byte[] bstream, int offset) {
        this.value = this.byteStreamToLongValue(bstream, offset);
    }

    public VariableFormatNumber(int intval) {
        this.value = (long)intval & 0xFFFFFFFFFFFFFFFFL;
    }

    public VariableFormatNumber(long longval) {
        this.value = longval;
    }

    public VariableFormatNumber(float floatval) {
        this.value = (long)floatval;
    }

    public VariableFormatNumber(double doubleval) {
        this.value = (long)doubleval;
    }

    public int intValue() {
        return (int)this.value & 0xFFFFFFFF;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte[] byteStream() {
        byte[] tmp = new byte[16];
        int cnt = 15;
        long copy = this.value;
        while (copy != 0L) {
            tmp[cnt] = (byte)(copy & 0x7FL);
            copy /= 128L;
            if (cnt != 15) {
                int n = cnt;
                tmp[n] = (byte)(tmp[n] | 0x80);
            }
            --cnt;
        }
        byte[] result = new byte[15 - cnt];
        if (result.length == 0) {
            return new byte[1];
        }
        System.arraycopy(tmp, cnt + 1, result, 0, 15 - cnt);
        return result;
    }

    private long byteStreamToLongValue(byte[] bstream, int offset) {
        long value = 0L;
        int i = offset;
        boolean loopf = true;
        while (loopf) {
            value += (long)(bstream[i] & 0x7F);
            if ((bstream[i] & 0x80) == 0) {
                loopf = false;
            } else {
                value <<= 7;
            }
            ++i;
        }
        return value;
    }
}

