/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.tools.wf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.common.util.StringUtils;

public class ConsolePanel
extends WindowPanel
implements ActionListener {
    private JTextField wordInputArea;
    private JTextArea documentInputArea;
    private JTextArea searchResultArea;
    private JButton doSearchButton;

    public ConsolePanel() {
        this.init();
    }

    public void init() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BorderLayout());
        JPanel wordPanel = new JPanel();
        wordPanel.setLayout(new BorderLayout());
        this.wordInputArea = new JTextField();
        this.doSearchButton = new JButton("search");
        this.doSearchButton.addActionListener(this);
        wordPanel.add((Component)this.wordInputArea, "Center");
        wordPanel.add((Component)this.doSearchButton, "East");
        searchPanel.add((Component)wordPanel, "North");
        this.documentInputArea = new JTextArea();
        searchPanel.add((Component)new JScrollPane(this.documentInputArea), "Center");
        this.setLayout(new GridLayout(2, 1));
        this.searchResultArea = new JTextArea();
        this.searchResultArea.setEditable(false);
        this.add(searchPanel);
        this.add(new JScrollPane(this.searchResultArea));
    }

    public void actionPerformed(ActionEvent e) {
        String word = this.wordInputArea.getText();
        String document = this.documentInputArea.getText();
        if (StringUtils.isEmpty((String)word) && StringUtils.isEmpty((String)document)) {
            return;
        }
        Integer[] pos = StringUtils.searchWordIndexes((String)document, (String)word);
        StringBuffer sb = new StringBuffer("\u691c\u7d22\u7d50\u679c:\n\n");
        if (pos == null || pos.length == 0) {
            sb.append("\u8a72\u5f53\u306a\u3057");
        } else {
            int i = 0;
            while (i < pos.length) {
                sb.append(String.valueOf(pos[i].toString()) + "\n");
                ++i;
            }
        }
        this.wordInputArea.setText("");
        this.searchResultArea.setText(sb.toString());
    }
}

