/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.tools.isys;

import java.io.File;
import org.logical_paradox.common.io.FileUtils;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.tools.isys.StubIndexAccessor;
import org.logical_paradox.koike.tools.isys.StubProperty;

public class IndexGenerator {
    public static final String DEFAULT_DATA_PATH = StubProperty.getProperty("docs.stubs.isys");
    public static final String DEFAULT_DOCUMENT_ENCODING = "UnicodeBig";
    public static final int DEFAULT_NGRAM_LENGTH = 2;
    private final String datapath;

    public IndexGenerator(String datapath_) {
        this.datapath = datapath_;
    }

    public void execute() throws Exception {
        StubIndexAccessor idxa = new StubIndexAccessor();
        File datadir = new File(this.datapath);
        if (!datadir.isDirectory()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Parser parser = new Parser(2);
        File[] nodelist = datadir.listFiles();
        int i = 0;
        while (i < nodelist.length) {
            if (nodelist[i].isDirectory() && !nodelist[i].getName().equals(".") && !nodelist[i].getName().equals("..") && !"CVS".equals(nodelist[i].getName())) {
                File[] documents = nodelist[i].listFiles();
                int j = 0;
                while (j < documents.length) {
                    if (documents[j].isFile()) {
                        String document = FileUtils.readFully((File)documents[j], (String)DEFAULT_DOCUMENT_ENCODING);
                        Term[] terms = parser.parse(document);
                        idxa.addTerm(String.valueOf(nodelist[i].getName()) + ":" + j, terms);
                    }
                    ++j;
                }
            }
            ++i;
        }
        idxa.close();
    }

    public static final void main(String[] args) throws Exception {
        String configfilename = DEFAULT_DATA_PATH;
        if (args.length == 1) {
            configfilename = args[0];
        }
        System.out.println("\u30b9\u30bf\u30d6\u7528\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30d5\u30a1\u30a4\u30eb\u3092\u51fa\u529b\u3057\u307e\u3059");
        IndexGenerator idxg = new IndexGenerator(configfilename);
        idxg.execute();
        System.out.println("\u30b9\u30bf\u30d6\u7528\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30d5\u30a1\u30a4\u30eb\u3092\u51fa\u529b\u3057\u307e\u3057\u305f");
    }
}

