/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexNotFoundException;
import org.logical_paradox.koike.core.parser.ParserException;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.ResultSet;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchEngine;
import org.logical_paradox.koike.core.search.SearchException;
import org.logical_paradox.koike.core.search.SearchResult;
import org.logical_paradox.koike.core.summary.DefaultSummaryGenerator;
import org.logical_paradox.koike.core.summary.SummaryGenerator;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperatorFactory;

public class RSSSearchEngine
extends SearchEngine {
    private static final SummaryGenerator summaryGenerator = new DefaultSummaryGenerator();

    protected RSSSearchEngine(KoikeConfig cfg) throws Exception {
        super(cfg);
    }

    public SearchResult search(SearchCondition condition) throws SearchException {
        ArrayList searchwords = new ArrayList();
        KoikeIndexResultSet indexes = this.retrieve(searchwords, condition);
        if (indexes == null || indexes.isEmpty()) {
            return null;
        }
        return this.fetchResults(indexes, condition, searchwords.toArray(new String[0]));
    }

    protected SearchResult fetchResults(KoikeIndexResultSet indexes, SearchCondition condition, String[] searchwords) throws SearchException {
        int doccnt = 0;
        int hits = 0;
        int skipcnt = condition.getStartp();
        ArrayList<ResultSet> results = new ArrayList<ResultSet>();
        Iterator it = indexes.iteratorInvertedIndexes();
        while (it.hasNext()) {
            InvertedIndex iidx = (InvertedIndex)it.next();
            String nodeId = iidx.getNodeId();
            int blkno = iidx.getBlockNo();
            long documents = iidx.getDocumentAvailability();
            int docno = blkno * 64;
            while (documents > 0L) {
                if ((documents & 1L) != 0L) {
                    ++hits;
                }
                documents >>>= 1;
            }
            documents = iidx.getDocumentAvailability();
            while ((doccnt < condition.getDispnum() || condition.getDispnum() == 0) && documents != 0L) {
                if ((documents & 1L) != 0L) {
                    if (skipcnt > 0) {
                        --skipcnt;
                    } else {
                        ++doccnt;
                        results.add(this.createResultSet(nodeId, docno, searchwords));
                    }
                }
                documents >>>= 1;
                ++docno;
            }
        }
        Comparator c = this.getComparator();
        if (c != null) {
            Collections.sort(results, c);
        }
        SearchResult sr = new SearchResult();
        sr.setResultSet(results.toArray(new ResultSet[0]));
        sr.setHits(hits);
        return sr;
    }

    protected ResultSet createResultSet(String nodeId, int docno, String[] terms) throws SearchException {
        try {
            Document document = this.getDocumentAccessor().getDocument(String.valueOf(nodeId) + ":" + docno);
            String summary = summaryGenerator.createSummary(document.getDocument(), terms);
            ContentsAttribute attribute = (ContentsAttribute)document.getAttribute();
            ResultSet rs = new ResultSet();
            rs.setNodeId(nodeId);
            rs.setDocno(docno);
            rs.setDocumentTitle(attribute.getTitle());
            rs.setSiteName(attribute.getSitename());
            rs.setUrl(attribute.getUrl());
            rs.setSummary(summary);
            return rs;
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected KoikeIndexResultSet retrieve(List searchwords, Element element) throws SearchException {
        if (element.getElementType() == 64) {
            searchwords.add(element.getAttribute());
            return this.executeQuery(element.getAttribute());
        }
        List childElements = element.getChildNodes();
        KoikeIndexResultSet[] childResults = new KoikeIndexResultSet[childElements.size()];
        int i = 0;
        while (i < childResults.length) {
            childResults[i] = this.retrieve(searchwords, (Element)childElements.get(i));
            if (childResults[i] == null) {
                return null;
            }
            ++i;
        }
        try {
            KoikeIndexResultSet[] results = LogicalOperatorFactory.getOperator(element.getElementType()).execute(childResults);
            return results == null || results.length == 0 ? null : results[0];
        }
        catch (LogicalOperationException e) {
            throw new SearchException(e);
        }
    }

    protected KoikeIndexResultSet executeQuery(String keyword) throws SearchException {
        try {
            String[] terms = this.getParser().split(keyword);
            KoikeIndexResultSet[] results = new KoikeIndexResultSet[terms.length];
            if (results == null || results.length == 0) {
                return null;
            }
            int i = 0;
            while (i < terms.length) {
                results[i] = this.getIndexAccessor().getValue(terms[i]);
                if (results[i] == null) {
                    return null;
                }
                if (i > 0) {
                    KoikeIndexResultSet[] andOperationApplied = LogicalOperatorFactory.getOperator(1).execute(new KoikeIndexResultSet[]{results[0], results[i]});
                    if (andOperationApplied == null) {
                        return null;
                    }
                    results[0] = andOperationApplied[0];
                    results[i] = andOperationApplied[1];
                }
                ++i;
            }
            KoikeIndexResultSet[] seqOperationApplied = LogicalOperatorFactory.getOperator(56).execute(results);
            if (seqOperationApplied == null) {
                return null;
            }
            return seqOperationApplied[0];
        }
        catch (IndexNotFoundException e) {
            return null;
        }
        catch (SearchException e) {
            throw e;
        }
        catch (ParserException e) {
            throw new SearchException(e);
        }
        catch (IndexAccessException e) {
            throw new SearchException(e);
        }
        catch (LogicalOperationException e) {
            throw new SearchException(e);
        }
    }

    protected Comparator getComparator() {
        return null;
    }
}

