/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.verifier.regexp.ElementToken;
import com.sun.msv.verifier.regexp.OptimizationTag;
import com.sun.msv.verifier.regexp.Token;

public class ResidualCalculator
implements ExpressionVisitorExpression {
    protected Token token;
    protected final ExpressionPool pool;

    public Expression onAnyString() {
        if (this.token.matchAnyString()) {
            return Expression.anyString;
        }
        return Expression.nullSet;
    }

    public Expression onEpsilon() {
        return Expression.nullSet;
    }

    public Expression onNullSet() {
        return Expression.nullSet;
    }

    public ResidualCalculator(ExpressionPool pool) {
        this.pool = pool;
    }

    public Expression onAttribute(AttributeExp exp) {
        if (this.token.match(exp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onChoice(ChoiceExp exp) {
        return this.pool.createChoice(exp.exp1.visit(this), exp.exp2.visit(this));
    }

    public Expression onConcur(ConcurExp exp) {
        return this.pool.createConcur(exp.exp1.visit(this), exp.exp2.visit(this));
    }

    public Expression onData(DataExp exp) {
        if (this.token.match(exp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onElement(ElementExp exp) {
        if (this.token.match(exp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onInterleave(InterleaveExp exp) {
        return this.pool.createChoice(this.pool.createInterleave(exp.exp1.visit(this), exp.exp2), this.pool.createInterleave(exp.exp1, exp.exp2.visit(this)));
    }

    public Expression onList(ListExp exp) {
        if (this.token.match(exp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onMixed(MixedExp exp) {
        if (this.token.matchAnyString()) {
            return exp;
        }
        return this.pool.createMixed(exp.exp.visit(this));
    }

    public Expression onOneOrMore(OneOrMoreExp exp) {
        return this.pool.createSequence(exp.exp.visit(this), this.pool.createZeroOrMore(exp.exp));
    }

    public Expression onOther(OtherExp exp) {
        return exp.exp.visit(this);
    }

    public Expression onRef(ReferenceExp exp) {
        return exp.exp.visit(this);
    }

    public Expression onSequence(SequenceExp exp) {
        Expression r = this.pool.createSequence(exp.exp1.visit(this), exp.exp2);
        if (exp.exp1.isEpsilonReducible()) {
            return this.pool.createChoice(r, exp.exp2.visit(this));
        }
        return r;
    }

    public Expression onValue(ValueExp exp) {
        if (this.token.match(exp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    final Expression calcResidual(Expression exp, ElementToken token) {
        if (token.acceptedPatterns != null && token.acceptedPatterns.length == 1) {
            Expression residual;
            OptimizationTag ot;
            if (exp.verifierTag == null) {
                ot = new OptimizationTag();
                exp.verifierTag = ot;
            } else {
                ot = (OptimizationTag)exp.verifierTag;
                residual = (Expression)ot.simpleElementTokenResidual.get(token.acceptedPatterns[0]);
                if (residual != null) {
                    return residual;
                }
            }
            this.token = token;
            residual = exp.visit(this);
            ot.simpleElementTokenResidual.put(token.acceptedPatterns[0], residual);
            return residual;
        }
        this.token = token;
        return exp.visit(this);
    }

    public final Expression calcResidual(Expression exp, Token token) {
        if (token instanceof ElementToken) {
            return this.calcResidual(exp, (ElementToken)token);
        }
        this.token = token;
        Expression r = exp.visit(this);
        if (token.isIgnorable()) {
            r = this.pool.createChoice(r, exp);
        }
        return r;
    }
}

